% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{c.classified}
\alias{c.classified}
\title{Combine Classified}
\usage{
\method{c}{classified}(
  ...,
  recursive = TRUE,
  warn_conflicted = getOption("yamlet_warn_conflicted", FALSE),
  reconcile_attributes = getOption("yamlet_reconcile_attributes", TRUE)
)
}
\arguments{
\item{...}{passed to next method}

\item{recursive}{passed to unlist() internally}

\item{warn_conflicted}{logical: warn if any duplicated codelist names?}

\item{reconcile_attributes}{logical: reconcile attribute lists (other than levels and attributes) if TRUE (default as of 1.3.1); else take attributes from first argument (former behavior)}
}
\value{
class 'classified' 'factor'
}
\description{
Combines classified factor, retaining attributes.
Attributes other than levels and codelist are taken
from the first argument if \code{reconcile_attributes} is FALSE;
otherwise remaining attributes are reconciled (default as of 1.3.1).
Attribute 'levels' is
supplied by next method.  Attribute 'codelist'
is the combined codelists in sequence of
all (dots) arguments, after silently removing
exact duplicates. If any names are duplicated,
the entire codelist is replaced by the effective levels,
with optional warning.
}
\examples{
a <- classified(letters[1:3])
b <- classified(letters[3:5])
c <- c(a,b)
c
class(c)

}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.dvec}()},
\code{\link{classified.factor}()},
\code{\link{desolve.classified}()},
\code{\link{unclassified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()}
}
\concept{classified}
\keyword{internal}
