% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codec.R
\docType{class}
\name{zarr_codec_zstd}
\alias{zarr_codec_zstd}
\title{Zarr "zstd" codec}
\description{
This class provides the codec for "zstd" compression.
}
\section{Super classes}{
\code{\link[zarr:zarr_extension]{zarr::zarr_extension}} -> \code{\link[zarr:zarr_codec]{zarr::zarr_codec}} -> \code{zarr_codec_zstd}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{level}}{The compression level of the zstd codec, an integer value
between 1L (fast) and 20 (maximum compression).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zarr_codec_zstd-new}{\code{zarr_codec_zstd$new()}}
\item \href{#method-zarr_codec_zstd-copy}{\code{zarr_codec_zstd$copy()}}
\item \href{#method-zarr_codec_zstd-encode}{\code{zarr_codec_zstd$encode()}}
\item \href{#method-zarr_codec_zstd-decode}{\code{zarr_codec_zstd$decode()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_codec" data-id="metadata_fragment"><a href='../../zarr/html/zarr_codec.html#method-zarr_codec-metadata_fragment'><code>zarr::zarr_codec$metadata_fragment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_codec" data-id="print"><a href='../../zarr/html/zarr_codec.html#method-zarr_codec-print'><code>zarr::zarr_codec$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_zstd-new"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_zstd-new}{}}}
\subsection{Method \code{new()}}{
Create a new "zstd" codec object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_zstd$new(configuration = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{configuration}}{Optional. A list with the configuration parameters
for this codec. The element \code{level} specifies the compression level of
this codec, ranging from 1 (no compression) to 20 (maximum compression).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_zstd-copy"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_zstd-copy}{}}}
\subsection{Method \code{copy()}}{
Create a new, independent copy of this codec.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_zstd$copy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An instance of \code{zarr_codec_zstd}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_zstd-encode"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_zstd-encode}{}}}
\subsection{Method \code{encode()}}{
This method encodes a raw data object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_zstd$encode(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The raw data to be encoded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The encoded raw data object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_codec_zstd-decode"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_codec_zstd-decode}{}}}
\subsection{Method \code{decode()}}{
This method decodes a raw data object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_codec_zstd$decode(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The raw data to be decoded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The decoded raw data object.
}
}
}
