




















//! # Pointers






//! # Pinning






//! # Garbage









//! # APIs




#![doc(test(
    no_crate_inject,
    attr(
        deny(warnings, rust_2018_idioms),
        allow(dead_code, unused_assignments, unused_variables)
    )
))]
#![warn(
    missing_docs,
    missing_debug_implementations,
    rust_2018_idioms,
    unreachable_pub
)]
#![cfg_attr(not(feature = "std"), no_std)]

#[cfg(crossbeam_loom)]
extern crate loom_crate as loom;

#[cfg(crossbeam_loom)]
#[allow(unused_imports, dead_code)]
mod primitive {
    pub(crate) mod cell {
        pub(crate) use loom::cell::UnsafeCell;
    }
    pub(crate) mod sync {
        pub(crate) mod atomic {
            pub(crate) use loom::sync::atomic::{fence, AtomicPtr, AtomicUsize, Ordering};

            
            
            
            
            
            pub(crate) use self::fence as compiler_fence;
        }
        pub(crate) use loom::sync::Arc;
    }
    pub(crate) use loom::thread_local;
}
#[cfg(target_has_atomic = "ptr")]
#[cfg(not(crossbeam_loom))]
#[allow(unused_imports, dead_code)]
mod primitive {
    pub(crate) mod cell {
        #[derive(Debug)]
        #[repr(transparent)]
        pub(crate) struct UnsafeCell<T>(::core::cell::UnsafeCell<T>);

        
        
        
        
        // https://github.com/tokio-rs/loom#handling-loom-api-differences
        impl<T> UnsafeCell<T> {
            #[inline]
            pub(crate) const fn new(data: T) -> UnsafeCell<T> {
                UnsafeCell(::core::cell::UnsafeCell::new(data))
            }

            #[inline]
            pub(crate) fn with<R>(&self, f: impl FnOnce(*const T) -> R) -> R {
                f(self.0.get())
            }

            #[inline]
            pub(crate) fn with_mut<R>(&self, f: impl FnOnce(*mut T) -> R) -> R {
                f(self.0.get())
            }
        }
    }
    pub(crate) mod sync {
        pub(crate) mod atomic {
            pub(crate) use core::sync::atomic::{
                compiler_fence, fence, AtomicPtr, AtomicUsize, Ordering,
            };
        }
        #[cfg(feature = "alloc")]
        pub(crate) use alloc::sync::Arc;
    }

    #[cfg(feature = "std")]
    pub(crate) use std::thread_local;
}

#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
extern crate alloc;

#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
mod atomic;
#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
mod collector;
#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
mod deferred;
#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
mod epoch;
#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
mod guard;
#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
mod internal;
#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
mod sync;

#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
#[allow(deprecated)]
pub use crate::atomic::{CompareAndSetError, CompareAndSetOrdering};
#[cfg(all(feature = "alloc", target_has_atomic = "ptr"))]
pub use crate::{
    atomic::{Atomic, CompareExchangeError, Owned, Pointable, Pointer, Shared},
    collector::{Collector, LocalHandle},
    guard::{unprotected, Guard},
};

#[cfg(feature = "std")]
mod default;
#[cfg(feature = "std")]
pub use crate::default::{default_collector, is_pinned, pin};
