use super::*;
use extendr_ffi::Rcomplex;































macro_rules! impl_synonym_type {
    ($type: ty, $synonym_type: ty) => {
        impl ToVectorValue for $type {
            fn sexptype() -> SEXPTYPE {
                <$synonym_type as ToVectorValue>::sexptype()
            }

            fn to_real(&self) -> f64
            where
                Self: Sized,
            {
                <$synonym_type as ToVectorValue>::to_real(&self.inner())
            }

            fn to_complex(&self) -> Rcomplex
            where
                Self: Sized,
            {
                <$synonym_type as ToVectorValue>::to_complex(&self.inner())
            }

            fn to_integer(&self) -> i32
            where
                Self: Sized,
            {
                <$synonym_type as ToVectorValue>::to_integer(&self.inner())
            }

            fn to_logical(&self) -> i32
            where
                Self: Sized,
            {
                <$synonym_type as ToVectorValue>::to_logical(&self.inner())
            }

            fn to_raw(&self) -> u8
            where
                Self: Sized,
            {
                <$synonym_type as ToVectorValue>::to_raw(&self.inner())
            }

            fn to_sexp(&self) -> SEXP
            where
                Self: Sized,
            {
                <$synonym_type as ToVectorValue>::to_sexp(&self.inner())
            }
        }
    };
}
impl_synonym_type!(Rfloat, f64);
impl_synonym_type!(&Rfloat, f64);
impl_synonym_type!(Rint, i32);
impl_synonym_type!(&Rint, i32);
