use super::*;












#[derive(PartialEq, Clone)]
pub struct Raw {
    pub(crate) robj: Robj,
}

fn init_raw<F: FnOnce(&mut [u8])>(len: usize, filler: F) -> Raw {
    let mut robj = Robj::alloc_vector(SEXPTYPE::RAWSXP, len);
    let slice = robj.as_raw_slice_mut().unwrap();
    filler(slice);
    Raw { robj }
}

impl Raw {
    
    
    
    
    
    
    
    
    
    pub fn new(len: usize) -> Raw {
        init_raw(len, |slice| slice.fill(0))
    }

    
    
    
    
    
    
    
    
    pub fn from_bytes(bytes: &[u8]) -> Self {
        init_raw(bytes.len(), |slice| slice.copy_from_slice(bytes))
    }

    
    pub fn as_slice(&self) -> &[u8] {
        self.robj.as_typed_slice().unwrap()
    }
}

impl std::fmt::Debug for Raw {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.write_str("Raw")?;
        f.debug_list().entries(self.as_slice()).finish()
    }
}

impl From<Option<Raw>> for Robj {
    fn from(value: Option<Raw>) -> Self {
        match value {
            None => nil_value(),
            Some(value) => value.into(),
        }
    }
}
