







use crate::imp_prelude::*;
use crate::slice::MultiSliceArg;
use num_complex::Complex;


impl<'a, A, D> ArrayView<'a, A, D>
where D: Dimension
{
    
    
    
    
    
    
    
    /// # use ndarray::prelude::*;
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # use ndarray::prelude::*;
    /// # let a = aview2(&[[0; 4]; 3]);
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # use ndarray::prelude::*;
    /// # let a = aview2(&[[0; 4]; 3]);
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    #[track_caller]
    #[inline]
    pub fn split_at(self, axis: Axis, index: Ix) -> (Self, Self)
    {
        unsafe {
            let (left, right) = self.into_raw_view().split_at(axis, index);
            (left.deref_into_view(), right.deref_into_view())
        }
    }
}

impl<'a, T, D> ArrayView<'a, Complex<T>, D>
where D: Dimension
{
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    pub fn split_complex(self) -> Complex<ArrayView<'a, T, D>>
    {
        unsafe {
            let Complex { re, im } = self.into_raw_view().split_complex();
            Complex {
                re: re.deref_into_view(),
                im: im.deref_into_view(),
            }
        }
    }
}


impl<'a, A, D> ArrayViewMut<'a, A, D>
where D: Dimension
{
    
    
    
    
    #[track_caller]
    #[inline]
    pub fn split_at(self, axis: Axis, index: Ix) -> (Self, Self)
    {
        unsafe {
            let (left, right) = self.into_raw_view_mut().split_at(axis, index);
            (left.deref_into_view_mut(), right.deref_into_view_mut())
        }
    }

    
    
    
    
    
    
    /// See [*Slicing*](#slicing) for full documentation. See also
    
    
    
    
    
    
    
    
    
    
    #[track_caller]
    pub fn multi_slice_move<M>(self, info: M) -> M::Output
    where M: MultiSliceArg<'a, A, D>
    {
        info.multi_slice_move(self)
    }
}

impl<'a, T, D> ArrayViewMut<'a, Complex<T>, D>
where D: Dimension
{
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    pub fn split_complex(self) -> Complex<ArrayViewMut<'a, T, D>>
    {
        unsafe {
            let Complex { re, im } = self.into_raw_view_mut().split_complex();
            Complex {
                re: re.deref_into_view_mut(),
                im: im.deref_into_view_mut(),
            }
        }
    }
}
