









//! # The parking lot



















//! # Building custom synchronization primitives








#![warn(missing_docs)]
#![warn(rust_2018_idioms)]
#![cfg_attr(
    all(target_env = "sgx", target_vendor = "fortanix"),
    feature(sgx_platform)
)]
#![cfg_attr(
    all(
        feature = "nightly",
        target_family = "wasm",
        target_feature = "atomics"
    ),
    feature(stdarch_wasm_atomic_wait)
)]

mod parking_lot;
mod spinwait;
mod thread_parker;
mod util;
mod word_lock;

pub use self::parking_lot::deadlock;
pub use self::parking_lot::{park, unpark_all, unpark_filter, unpark_one, unpark_requeue};
pub use self::parking_lot::{
    FilterOp, ParkResult, ParkToken, RequeueOp, UnparkResult, UnparkToken,
};
pub use self::parking_lot::{DEFAULT_PARK_TOKEN, DEFAULT_UNPARK_TOKEN};
pub use self::spinwait::SpinWait;
