% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/price_impact_utils.R
\name{compute_p_adj}
\alias{compute_p_adj}
\title{Compute Adjusted Risk-Neutral Probability}
\usage{
compute_p_adj(r, u, d, lambda, v_u, v_d)
}
\arguments{
\item{r}{Gross risk-free rate per period}

\item{u}{Base up factor}

\item{d}{Base down factor}

\item{lambda}{Price impact coefficient}

\item{v_u}{Hedging volume on up move}

\item{v_d}{Hedging volume on down move}
}
\value{
Adjusted risk-neutral probability (numeric)
}
\description{
Calculates the adjusted risk-neutral probability incorporating
price impact from hedging activities.
}
\examples{
compute_p_adj(r = 1.05, u = 1.2, d = 0.8, lambda = 0.1, v_u = 1, v_d = 1)
}
