% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.data.R
\name{init.data}
\alias{init.data}
\title{Initialize Data Array for BCFM Model}
\usage{
init.data(data, cluster.vars = NULL)
}
\arguments{
\item{data}{A data frame, matrix, or 3D array containing the data to be used
for clustering. If a 3D array with appropriate dimensions is provided and
cluster.vars is NULL, the function returns the data unchanged.}

\item{cluster.vars}{A character vector specifying the column names of variables
to be used for clustering (required for data frames). If NULL and data is
already a 3D array, the function returns data as-is. If NULL and data is a
matrix, all columns are used.}
}
\value{
A 3D array with dimensions (n, p, t) where n is the number of
observations, p is the number of clustering variables, and t is the number
of time points (defaults to 1 for cross-sectional data).
}
\description{
Prepares the input data by converting it into a 3D array format
required by the BCFM model. If data is already in the correct 3D array format,
it returns the data as-is. Takes selected clustering variables and creates
an array with dimensions (observations, variables, time points).
}
\examples{
\donttest{
# Example 1: Data frame with variable selection
data <- data.frame(x1 = rnorm(100), x2 = rnorm(100), x3 = rnorm(100))
cluster.vars <- c("x1", "x2", "x3")
data.pre <- init.data(data, cluster.vars)

# Example 2: Matrix (uses all columns)
data_matrix <- matrix(rnorm(300), nrow = 100, ncol = 3)
data.pre <- init.data(data_matrix)

# Example 3: 3D array (returns as-is)
data_3d <- array(rnorm(1500), dim = c(100, 3, 5))
data.pre <- init.data(data_3d)  # Returns unchanged
}

}
