% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.bold.apikey.R
\name{bold.apikey}
\alias{bold.apikey}
\title{Set the BOLD private data API key}
\usage{
bold.apikey(apikey)
}
\arguments{
\item{apikey}{A character string required for authentication and data access.}
}
\value{
Token saved as 'apikey'
}
\description{
Stores the BOLD-provided access token ‘apikey’ in a variable, making it available for use in other functions within the R session.
}
\details{
\code{bold.apikey} creates a variable called \code{apikey} that stores the access token provided by BOLD. This apikey variable is then used internally by the \code{\link[=bold.fetch]{bold.fetch()}} and \code{\link[=bold.full.search]{bold.full.search()}} functions, so that the user does not have to input it again. To set the \code{apikey}, the token must be provided as an input for the function before any other functions are called. The \code{apikey} is a UUID v4 hexadecimal string and is valid for few months,  after which it must be renewed.

\emph{Obtaining the API key}: The API key is found in the BOLD Workbench(\url{https://bench.boldsystems.org/index.php/Login/page?destination=MAS_Management_UserConsole}). After logging in, navigate to \verb{Your Name} (located at the top left-hand side of the window) and click \verb{Edit User Preferences}. You can find the API key in the \verb{User Data} section.

\emph{Please note}: To have an API key available in the workbench, a user must have uploaded ~ 10K records to BOLD, though, in case there aren't those many submissions on BOLD, the user can email BOLD support to request for a token. Such requests will be assessed on a case by case basis.
}
\examples{
\dontrun{

#This example below is for documentation only

bold.apikey('00000000-0000-0000-0000-000000000000')

}


}
