% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_plot.R
\name{heat_plot}
\alias{heat_plot}
\title{Heat plot of posterior probabilities}
\usage{
heat_plot(model_fit, ...)
}
\arguments{
\item{model_fit}{An object of type \code{BayesMallows}, returned from
\code{\link[=compute_mallows]{compute_mallows()}}.}

\item{...}{Additional arguments passed on to other methods. In particular,
\code{type = "CP"} or \code{type = "MAP"} can be passed on to
\code{\link[=compute_consensus]{compute_consensus()}} to determine the order of items along the
horizontal axis.}
}
\value{
A ggplot object.
}
\description{
Generates a heat plot with items in their consensus ordering along the
horizontal axis and ranking along the vertical axis. The color denotes
posterior probability.
}
\details{
In models with a single cluster, the items are sorted along the
x-axis according to the consensus ranking. In models with more than one
cluster, the items are sorted alphabetically.
}
\examples{
set.seed(1)
model_fit <- compute_mallows(
  setup_rank_data(potato_visual),
  compute_options = set_compute_options(nmc = 2000, burnin = 500))

heat_plot(model_fit)
heat_plot(model_fit, type = "MAP")

## Model with three clusters
mod <- compute_mallows(
  data = setup_rank_data(rankings = cluster_data),
  model_options = set_model_options(n_clusters = 3),
  compute_options = set_compute_options(nmc = 10000, burnin = 1000)
)

heat_plot(mod)
heat_plot(mod, type = "MAP")
}
\seealso{
Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{get_acceptance_ratios}()},
\code{\link{plot.BayesMallows}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{predict_top_k}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
