/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree.treemetrics;

import dr.evolution.tree.Tree;

public interface TreeMetric {
    public double getMetric(Tree var1, Tree var2);

    public Type getType();

    public static class Utils {
        static void checkTreeTaxa(Tree tree, Tree tree2) {
            if (tree.getExternalNodeCount() != tree2.getExternalNodeCount()) {
                throw new RuntimeException("Different number of taxa in both trees.");
            }
            for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
                if (tree.getNodeTaxon(tree.getExternalNode(i)).getId().equals(tree2.getNodeTaxon(tree2.getExternalNode(i)).getId())) continue;
                throw new RuntimeException("Mismatch between taxa in both trees: " + tree.getNodeTaxon(tree.getExternalNode(i)).getId() + " vs. " + tree2.getNodeTaxon(tree2.getExternalNode(i)).getId());
            }
        }
    }

    public static enum Type {
        ROBINSON_FOULDS("Robinson-Foulds", "rf"),
        BRANCH_SCORE("branch score", "branchscore"),
        ROOTED_BRANCH_SCORE("rooted branch score", "branch"),
        CLADE_HEIGHT("clade height", "clade"),
        KENDALL_COLIJN("Kendall-Colijn path difference", "kc"),
        STEEL_PENNY("Steel-Penny path difference", "sp");

        private final String name;
        private final String stortName;

        private Type(String string2, String string3) {
            this.name = string2;
            this.stortName = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.stortName;
        }

        public String toString() {
            return this.getName();
        }
    }
}

