% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_similarity_xy}
\alias{visualize_similarity_xy}
\title{Visualize similarity in low vs non-low frequency space}
\usage{
visualize_similarity_xy(
  similarity_results,
  point_size = 2,
  point_color = "steelblue",
  add_diagonal = TRUE,
  add_axes_lines = TRUE,
  title = "Low-frequency vs Non-low-frequency Similarity",
  show_labels = FALSE,
  show_names = FALSE
)
}
\arguments{
\item{similarity_results}{List of similarity results from runSGCC function, or a single result}

\item{point_size}{Size of points in the plot (default: 2)}

\item{point_color}{Color of points (default: "steelblue")}

\item{add_diagonal}{Whether to add diagonal reference lines (default: TRUE)}

\item{add_axes_lines}{Whether to add x=0 and y=0 reference lines (default: TRUE)}

\item{title}{Plot title (default: "Low-frequency vs Non-low-frequency Similarity")}

\item{show_labels}{Whether to show point labels if names are available (default: FALSE)}

\item{show_names}{Whether to display data point names as text labels using ggrepel (default: FALSE).
If more than 50 points, randomly samples 50 for labeling. Requires ggrepel package.}
}
\value{
ggplot object showing similarity space visualization
}
\description{
Create a scatter plot with low-frequency similarity (c_low) on x-axis
and non-low-frequency similarity (c_nonlow) on y-axis from runSGCC results
}
\examples{
\donttest{
# Create example data and compute SGWT
data <- data.frame(x = runif(100), y = runif(100),
                  signal1 = rnorm(100), signal2 = rnorm(100))
SG <- initSGWT(data, signals = c("signal1", "signal2"))
SG <- runSpecGraph(SG, k = 15)
SG <- runSGWT(SG)

# Single similarity result
sim_result <- runSGCC("signal1", "signal2", SG = SG)
plot <- visualize_similarity_xy(sim_result)
print(plot)

# Multiple similarity results (create two different analyses)
data2 <- data.frame(x = runif(100), y = runif(100),
                   signal1 = rnorm(100), signal2 = rnorm(100))
SG2 <- initSGWT(data2, signals = c("signal1", "signal2"))
SG2 <- runSpecGraph(SG2, k = 15)
SG2 <- runSGWT(SG2)

sim_results <- list(
  pair1 = runSGCC("signal1", "signal2", SG = SG),
  pair2 = runSGCC("signal1", "signal2", SG = SG2)
)
plot <- visualize_similarity_xy(sim_results, show_names = TRUE)
print(plot)
}
}
