% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_binned_MannWhitney.R
\name{ch_binned_MannWhitney}
\alias{ch_binned_MannWhitney}
\title{Compares two time periods of data using Mann-Whitney test}
\usage{
ch_binned_MannWhitney(
  DF,
  step,
  range1,
  range2,
  ptest = 0.05,
  variable = "discharge",
  metadata = NULL
)
}
\arguments{
\item{DF}{A data frame of hydrometric data from \code{ch_read_ECDE_flows}}

\item{step}{An integer indicating the degree of smoothing eg. 1, 5, 11.}

\item{range1}{The first and last year of first period, as \code{c(first,last)}}

\item{range2}{The first and last year of second period, as \code{c(first,last)}}

\item{ptest}{The significance level default is \code{0.05}.}

\item{variable}{Name of variable. Default is \option{discharge}}

\item{metadata}{dataframe of station metadata, default is HYDAT_list}
}
\value{
Returns a list containing:
 \item{StationID}{ID of station}
 \item{Station_lname}{Name of station}
 \item{bin_width}{Smoothing time step}
 \item{range1}{First range of years}
 \item{range2}{Second range of years}
 \item{p_used}{p_value}
 \item{fail}{TRUE if test failed due to missing values}
 \item{bin_method}{method used for binning}
 \item{test_method}{Mann-Whitney U-statistic}
 \item{series}{a data frame containing:}
	\item{period}{period numbers i.e. 1:365/step}
	\item{period1}{median values for each bin in period 1}
	\item{period2}{median values for each bin in period 2}
	\item{mwu}{Mann-Whitney U-statistic for each bin between the two periods}
	\item{prob}{probability of U-statistic for each period}
	\item{code}{significance codes for each bin}
}
\description{
Compares two time periods of data using the Mann-Whitney test. 
Data are binned based upon a bin size, and data are extracted for two time periods 
and tests for change between two such periods
result can be passed to \code{ch_polar_plot} or \code{ch_decades_plot} 
for visualization.
}
\examples{
data(HYDAT_list)
data(CAN05AA008)
# first example fails due to missing data in both periods
range1 <- c(1960,1969)
range2 <- c(1990,1999)
b_MW <- ch_binned_MannWhitney(CAN05AA008, step = 5, range1, range2, ptest = 0.05)

range1 <- c(1970,1979)
range2 <- c(1990,1999)
b_MW <- ch_binned_MannWhitney(CAN05AA008, step = 5, range1, range2, ptest = 0.05)

}
\references{
Whitfield, P.H., Cannon, A.J., 2000. Recent variations in climate and 
hydrology in Canada. Canadian Water Resources Journal 25: 19-65.
}
\seealso{
\code{\link{ch_polar_plot}} \code{\link{ch_polar_plot_prep}} 
\code{\link{ch_decades_plot}}
}
\author{
Paul Whitfield
}
