% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_sub_set_Years.R
\name{ch_sub_set_Years}
\alias{ch_sub_set_Years}
\title{Helper function for selecting points for an axis}
\usage{
ch_sub_set_Years(years, n)
}
\arguments{
\item{years}{a vector of years}

\item{n}{sample size}
}
\value{
a list containing:
	\item{position}{array of axis positions}
	\item{label}{array of labels}
}
\description{
Sub-samples a vector every n places. Many times there are so many 
years the labels on the plot overlap. \code{ch_sub_set_years} returns the position and label 
for the subset. The function can be used on any type of simple array.
}
\examples{
myears <- c(1900:2045)
myears <- ch_sub_set_Years(myears, 20)
myears

a <- LETTERS
my_alpha <- ch_sub_set_Years(a, 5)
my_alpha
}
\author{
Paul Whitfield
}
