% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_metamodel.R
\name{parse_NLMEHosts}
\alias{parse_NLMEHosts}
\title{Create NlmeParallelHost object from json file with host definition}
\usage{
parse_NLMEHosts(nlme_hostPath)
}
\arguments{
\item{nlme_hostPath}{json file with host definition for model execution.
See \code{NlmeParallelHost} class definition.
If \code{missing}, MPI local host with 4 threads is used for simple estimation
mode, multicore host is used for the others.}
}
\value{
the \code{NlmeParallelHost} class object is returned.
}
\description{
Create NlmeParallelHost object from json file with host definition
}
\examples{
\dontrun{
# path nlme_hostPath should be specified
 nlme_hostPath <- tempfile()
 host1 <- paste0('{"profile_name":"Multicore",',
  '"hostname":"127.0.0.1",',
  '"cores_number":4,',
  '"parallel_mode":"MULTICORE"}')
 host2 <- paste0('{"profile_name":"MPI",',
 '"hostname":"127.0.0.1",',
 '"cores_number":8,',
 '"parallel_mode":"LOCAL_MPI"}')

writeLines(paste0("[", host1, ",", host2, "]"), nlme_hostPath)
hosts <- parse_NLMEHosts(nlme_hostPath)
}
}
\keyword{internal}
