% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFM.R
\name{CoFM}
\alias{CoFM}
\title{Generate Copula Factor Models Data and Perform Tests}
\usage{
CoFM(n = 1000, p = 10, m = 5, type = "Clayton", param = 2)
}
\arguments{
\item{n}{Integer. Sample size (number of rows). Default is 1000.}

\item{p}{Integer. Number of observed variables (columns). Default is 10.}

\item{m}{Integer. Number of factors. Default is 5.}

\item{type}{Character. The type of Copula for error terms. Options: "Clayton", "Gumbel", "Frank".}

\item{param}{Numeric. The parameter for the Copula (theta). Default is 2.0.}
}
\value{
A list containing:
\item{data}{The generated data matrix (n x p).}
\item{KMO}{The results of the Kaiser-Meyer-Olkin test.}
\item{Bartlett}{The results of Bartlett's test of sphericity.}
\item{True_Params}{A list containing the true parameters used (F, A, D, mu).}
}
\description{
This function simulates data based on a Copula Factor Model structure.
It generates factor scores, factor loadings, and error terms (using specified Copula
distributions), combines them to create the observed data, and then performs KMO and
Bartlett's tests on the generated data.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)

# Clayton copula errors (toy size)
res1 <- CoFM::CoFM(n = 200, p = 6, m = 2, type = "Clayton", param = 2)
res1$KMO
res1$Bartlett

# Gumbel copula errors (toy size)
res2 <- CoFM::CoFM(n = 150, p = 6, m = 2, type = "Gumbel", param = 2)
head(res2$data)

}
