% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCodeUse.R
\name{summariseCohortCodeUse}
\alias{summariseCohortCodeUse}
\title{Summarise code use among a cohort in the cdm reference}
\usage{
summariseCohortCodeUse(
  cdm,
  cohortTable,
  x = NULL,
  cohortId = NULL,
  timing = "any",
  countBy = c("record", "person"),
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL,
  useSourceCodes = FALSE
)
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{cohortTable}{A cohort table from the cdm reference.}

\item{x}{A codelist or cohort table name.}

\item{cohortId}{A vector of cohort IDs to include}

\item{timing}{When to assess the code use relative cohort dates. This can
be "any"(code use any time by individuals in the cohort) or  "entry" (code
use on individuals' cohort start date).}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts.}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by
concept.}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}

\item{useSourceCodes}{Whether the codelist provided contains source codes
(TRUE) or standard codes (FALSE).}
}
\value{
A tibble with results overall and, if specified, by strata
}
\description{
Summarise code use among a cohort in the cdm reference
}
\examples{
\dontrun{
library(CodelistGenerator)
library(duckdb)
library(DBI)
library(CDMConnector)
con <- dbConnect(duckdb(),
                 dbdir = eunomiaDir())
cdm <- cdmFromCon(con,
                 cdmSchema = "main",
                 writeSchema = "main")
cdm <- generateConceptCohortSet(cdm = cdm,
                  conceptSet = list(a = 260139,
                                    b = 1127433),
                  name = "cohorts",
                  end = "observation_period_end_date",
                  overwrite = TRUE)

results_cohort_mult <-
summariseCohortCodeUse(omopgenerics::newCodelist(list(cs = c(260139,19133873))),
                      cdm = cdm,
                      cohortTable = "cohorts",
                      timing = "entry")

results_cohort_mult
CDMConnector::cdmDisconnect(cdm)
}
}
