% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deathCohort.R
\name{deathCohort}
\alias{deathCohort}
\title{Create cohort based on the death table}
\usage{
deathCohort(cdm, name, subsetCohort = NULL, subsetCohortId = NULL)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{subsetCohort}{A character refering to a cohort table containing
individuals for whom cohorts will be generated. Only individuals in this
table will appear in the generated cohort.}

\item{subsetCohortId}{Optional. Specifies cohort IDs from the \code{subsetCohort}
table to include. If none are provided, all cohorts from the \code{subsetCohort}
are included.}
}
\value{
A cohort table with a death cohort in cdm
}
\description{
Create cohort based on the death table
}
\examples{
\donttest{
if(isTRUE(omock::isMockDatasetDownloaded("GiBleed"))){
library(CohortConstructor)

cdm <- mockCohortConstructor()

# Generate a death cohort
death_cohort <- deathCohort(cdm, name = "death_cohort")
death_cohort

# Create a death cohort for females aged over 50 years old.

# Create a demographics cohort with age range and sex filters
cdm$my_cohort <- demographicsCohort(cdm, "my_cohort", ageRange = c(50,100), sex = "Female")

# Generate a death cohort, restricted to individuals in 'my_cohort'
death_cohort <- deathCohort(cdm, name = "death_cohort", subsetCohort = "my_cohort")
death_cohort |> attrition()
}
}
}
