% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireIsEntry.R
\name{requireIsLastEntry}
\alias{requireIsLastEntry}
\title{Restrict cohort to last entry per person}
\usage{
requireIsLastEntry(cohort, cohortId = NULL, name = tableName(cohort))
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
A cohort table in a cdm reference.
}
\description{
\code{requireIsLastEntry()} filters cohort records, keeping only the last
cohort entry per person.
}
\examples{
\donttest{
library(CohortConstructor)
if(isTRUE(omock::isMockDatasetDownloaded("GiBleed"))){
cdm <- mockCohortConstructor()
cdm$cohort1 <- requireIsLastEntry(cdm$cohort1)
}
}

}
