% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSurvival.R
\name{tableSurvivalEvents}
\alias{tableSurvivalEvents}
\title{Table with survival events}
\usage{
tableSurvivalEvents(
  x,
  eventGap = NULL,
  header = c("estimate"),
  type = "gt",
  groupColumn = NULL,
  hide = c("result_id", "estimate_type"),
  style = NULL,
  .options = list()
)
}
\arguments{
\item{x}{Result from estimateSingleEventSurvival or estimateCompetingRiskSurvival.}

\item{eventGap}{Event gap defining the times at which to report the risk table
information. Must be one of the eventGap inputs used for the estimation function.
If NULL, all available are reported.}

\item{header}{A vector specifying the elements to include in the header.
The order of elements matters, with the first being the topmost header.
Elements in header can be:
\itemize{
\item Any of the columns returned by \code{tableColumns(result)} to create a header
for these columns.
\item Any other input to create an overall header.
}}

\item{type}{Character string specifying the desired output table format.
See \code{tableType()} for supported table types. If \code{type = NULL}, global
options (set via \code{setGlobalTableOptions()}) will be used if available;
otherwise, a default \code{'gt'} table is created.}

\item{groupColumn}{Columns to use as group labels, to see options use
\code{tableColumns(result)}. By default, the name of the new group will be the
tidy* column names separated by ";". To specify a custom group name, use a
named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts to sentence case. Use \code{rename} to customise specific column names.}

\item{hide}{Columns to drop from the output table. By default, \code{result_id} and
\code{estimate_type} are always dropped.}

\item{style}{Defines the visual formatting of the table.
This argument can be provided in one of the following ways:
\enumerate{
\item \strong{Pre-defined style:} Use the name of a built-in style (e.g., \code{"darwin"}).
See \code{tableStyle()} for available options.
\item \strong{YAML file path:} Provide the path to an existing \code{.yml} file defining
a new style.
\item \strong{List of custome R code:} Supply a block of custom R code or a named list
describing styles for each table section. This code must be specific to
the selected table type.
If \code{style = NULL}, the function will use global options
(see \code{setGlobalTableOptions()}) or an existing \verb{_brand.yml} file (if found);
otherwise, the default style is applied.
For more details, see the \emph{Styles} vignette on the package website.
}}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default values.}
}
\value{
A tibble containing the risk table information (n_risk, n_events, n_censor)
for all times within the event gap specified.
}
\description{
Table with survival events
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(cdm,
                                    targetCohortTable = "mgus_diagnosis",
                                    outcomeCohortTable = "death_cohort")
tableSurvivalEvents(surv)
}
}
