% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{plotDeparcs}
\alias{plotDeparcs}
\title{Plots a graph representation of dependency values}
\usage{
plotDeparcs(
  data,
  axis.at.bottom = TRUE,
  add.legend = TRUE,
  show.pvals = FALSE,
  axis.labels = NULL,
  threshold = 0.1
)
}
\arguments{
\item{data}{the \link{DLData} object containing the data}

\item{axis.at.bottom}{if \code{TRUE}, the x-axis is shown at the bottom
(side=1) of the plot, and at the top (side=3) otherwise}

\item{add.legend}{if \code{TRUE} a legend of the color scale is added to the
plot}

\item{show.pvals}{if \code{TRUE}, -log10 p-values (computed by
\link[stats]{pchisq}) are shown instead of mutual information values}

\item{axis.labels}{the labels of the x-axis}

\item{threshold}{threshold in mutual information values, edges below this value are not shown; ignored in \code{show.pvals=TRUE}}
}
\description{
Plots a representation of dependency values as arcs between the sequence
positions. Internally, dependency values are computed using \link{getDeps} on
the \code{data} object.
}
\examples{
# create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[,1], weights = log1p(seqs[, 2]) )

# plot using default parameters
plotDeparcs(data)

# plot with axis at top, without a legend (color scale), and using p-values
plotDeparcs(data, axis.at.bottom = FALSE, add.legend = FALSE, show.pvals = TRUE)
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
