% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{summary.DLData}
\alias{summary.DLData}
\title{Summarizing DLData objects}
\usage{
\method{summary}{DLData}(object, delete.gaps = FALSE, ...)
}
\arguments{
\item{object}{an object of class "DLData"}

\item{delete.gaps}{if gaps should be removed from the consensus}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} with elements \code{members} containing the number of sequences,
  \code{consensus} containing the consensus sequences, and \code{equal.consensus} containing the
  number of sequences in \code{object} that are identical to \code{consensus}
}
\description{
\code{summary} method for class "DLData".
The summary includes the number of sequences, the consensus sequence
and the number of sequences in \code{object} that match the consensus.
}
\examples{
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1], weights = log1p(seqs[, 2]) )
summary(data)
}
\author{
Jens Keilwagen, Jan Grau <grau@informatik.uni-halle.de>
}
