% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swimmerplot.R
\name{edc_swimmerplot}
\alias{edc_swimmerplot}
\title{Swimmer plot of all dates columns}
\usage{
edc_swimmerplot(
  ...,
  include = NULL,
  exclude = NULL,
  group = NULL,
  origin = NULL,
  data_list = get_datasets(),
  id_subset = "all",
  id_sort = FALSE,
  id_cols = get_subjid_cols(),
  time_unit = c("days", "weeks", "months", "years"),
  origin_fun = "min",
  aes_color = c("variable", "label"),
  plotly = getOption("edc_plotly", FALSE),
  id = "deprecated",
  id_lim = "deprecated",
  .lookup = "deprecated"
)
}
\arguments{
\item{...}{not used}

\item{include, exclude}{a character vector of variables to exclude/include, in the form \code{dataset$column}. Can be a regex (apart from \code{$} symbols that will be automatically escaped). Case-insensitive.}

\item{group}{a grouping variable, given as "dataset$column".}

\item{origin}{a variable to consider as time 0, given as "dataset$column".}

\item{data_list}{a named list of data.frames to get the dates from. Default to \link{get_datasets}, which retrieve all raw datasets.}

\item{id_subset}{the subjects to include in the plot.}

\item{id_sort}{whether to sort subjects by date (or time).}

\item{id_cols}{the subject identifiers columns. Identifiers be coerced as numeric if possible. See \link{get_subjid_cols} if needed.}

\item{time_unit}{if \code{origin!=NULL}, the unit to measure time. One of \code{c("days", "weeks", "months", "years")}.}

\item{origin_fun}{function to summarise the \code{origin} date at the id level if needed. Should be named, or at least have a meaningful function name (see example "summarized origin".}

\item{aes_color}{either \code{variable} ("\{dataset\} - \{column\}") or \code{label} (the column label).}

\item{plotly}{whether to use \code{{plotly}} to get an interactive plot.}

\item{id}{deprecated}

\item{id_lim}{deprecated}

\item{.lookup}{deprecated}
}
\value{
either a \code{plotly} or a \code{ggplot}
}
\description{
Join all tables on \code{id} with only date columns to build a ggplot (or a
plotly if \code{plotly=TRUE}) showing all dates for each subject. \cr
This allows outliers to be easily identified.
}
\examples{
#db = read_trialmaster("filename.zip", pw="xx")
db = edc_example()
load_database(db)
edc_swimmerplot(id_lim=c(5,45))

#fixed origin
edc_swimmerplot(origin="enrol$enrol_date", time_unit="months", 
                include=c("data1", "data3"),
                exclude=c("DATA1$DATE2", "data3$date\\\\d\\\\d"), 
                id_sort=TRUE)

#summarised origin
edc_swimmerplot(origin="data1$date2", time_unit="months", 
                origin_fun=c("average"=~mean(.x, na.rm=TRUE)),
                include=c("data1", "data3"),
                exclude=c("DATA1$DATE2", "data3$date\\\\d\\\\d"), 
                id_sort=TRUE)

#id_subset
edc_swimmerplot(group="enrol$arm", id_subset=1:10, aes_color="label")

\dontrun{
p = edc_swimmerplot(plotly=TRUE)
save_plotly(p, "edc_swimmerplot.html")
}
}
