% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_entity_sizes.R
\name{read_data_entity_sizes}
\alias{read_data_entity_sizes}
\title{Read data entity sizes}
\usage{
read_data_entity_sizes(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame) Size (in bytes) and identifiers of data entities in
\code{packageId}
}
\description{
Read data entity sizes
}
\examples{
\dontrun{

# Read entity sizes
sizes <- read_data_entity_sizes(packageId = "knb-lter-bnz.786.3")
sizes
#>                           entityId   size
#> 1 66bf513405f7799c35f24e4b33f7d835  19513
#> 2 33d2d8cedeea9d5dbefc973680d4557e  26429
#> 3 197b0d4372ecabd697cfd5ff1157e41b   2295
#> 4 bb8cdcf1d6f06f61007620bfa5333f2a 123366
#> 5 0916ac12f9896c35a27ea156c653718e  46475
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
