% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_package_report.R
\name{read_data_package_report}
\alias{read_data_package_report}
\title{Read data package report}
\usage{
read_data_package_report(packageId, as = "xml", env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{as}{(character) Format of the returned report. Can be: "xml",
"html", or "char".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(xml_document) Data package report
}
\description{
Read data package report
}
\examples{
\dontrun{

# Read as XML
qualityReport <- read_data_package_report("knb-lter-knz.260.4")
qualityReport
#> {xml_document}
#> <qualityReport schemaLocation="eml://ecoinformatics.org/qualityReport ...
#>  [1] <creationDate>2020-02-04T16:38:38</creationDate>
#>  [2] <packageId>knb-lter-knz.260.4</packageId>
#>  [3] <includeSystem>lter</includeSystem>
#>  [4] <includeSystem>knb</includeSystem>
#>  [5] <datasetReport>\n  <qualityCheck qualityType="metadata" system=" ...
#>  [6] <entityReport>\n  <entityName>GIS600</entityName>\n  <qualityChe ...
#>  [7] <entityReport>\n  <entityName>KMZGIS600</entityName>\n  <quality ...
#>  [8] <entityReport>\n  <entityName>GIS605</entityName>\n  <qualityChe ...
#>  [9] <entityReport>\n  <entityName>KMZGIS605</entityName>\n  <quality ...
#> [10] <entityReport>\n  <entityName>GIS610</entityName>\n  <qualityChe ...
#> ...

# Read as HTML
qualityReport <- read_data_package_report(
 packageId = "knb-lter-knz.260.4",
 as = "html"
)
qualityReport
#> {html_document}
#> <html>
#> [1] <body><table xmlns:qr="eml://ecoinformatics.org/qualityReport"><t ...

# Read as character
qualityReport <- read_data_package_report(
 packageId = "knb-lter-knz.260.4",
 as = "char"
)
# writeLines(qualityReport, paste0(tempdir(), "/report.txt"))
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
