% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EZbakRFractions.R
\name{EZbakRFractions}
\alias{EZbakRFractions}
\title{\code{EZbakRFractions} helper function for users}
\usage{
EZbakRFractions(fractions, metadf, name = NULL, character_limit = 20)
}
\arguments{
\item{fractions}{Data frame with the following columns:
\itemize{
\item sample: Name given to particular sample from which data was collected.
\item estimates of population fractions: These columns refer to the estimate
for the fraction of reads coming from a particular mutational population.
For example, in a standard NR-seq experiment, you should have one column
named \code{fraction_highTC}. This refers to the fraction of RNA inferred to have
a high T-to-C mutation rate (e.g., the newly synthesized RNA in a pulse-labeling NR-seq
experiment).
If you estimated the fractions of more than 2 mutation types (e.g., T-to-C and
G-to-A), then you need to explicitly list all fractions of interest estimated.
For example, in a TILAC experiment, this would be \code{fraction_highTC_lowGA},
\code{fraction_lowTC_highGA}, and \code{fraction_lowTC_lowGA}.
\item n: Number of reads assigned to a given feature in a given sample.
\item features: Any columns that cannot be interpreted as an estimate of
population fractions (and that aren't named \code{sample} or \code{n}) will be
interpreted as an ID for a genomic "feature" from which a read originated.
Common examples of features and typical column names for said features include:
\itemize{
\item Genes; common column names: gene, gene_id, gene_name, GF
\item Genes-exonic; common column names: gene_exon, gene_id_exon, gene_name_exon, XF
\item Transcripts; common column names: transcripts, TF
\item Exonic bins; common column names: exonic_bins, EF, EB
\item Exons; common column names: exons, exon_ids
}
In some cases, a read will often map to multiple features (e.g., exons). Many
functions in bakR expect each of the feature IDs in these cases to be separated
by \code{+}. For example, if a read overlaps with two exons, with IDs exon_1 and exon_2,
then the corresponding entry in a  column of exonic assignments would be "exon_1+exon_2".
The default expectation can be overwritten though and is thus not strictly enforced.
\item n: Number of reads with identical values for all other columns.
}}

\item{metadf}{Data frame detailing various aspects of each of the samples included
in the fractions data frame. This includes:
\itemize{
\item \code{sample}: The sample ID, which should correspond to a sample ID in the provided fractions data frame.
\item \code{tl}: Metabolic label time. There are several edge cases to be aware of:
\itemize{
\item If more than one metabolic label was used in the set of samples described
by the metadf (e.g., s4U and s6G were used), then the \code{tl} column should be
replaced by \verb{tl_<muttype>}, where \verb{<muttype>} represents the corresponding mutation
type referenced in the fractions that the label whose incubation time will be listed
in this column. For example, if feeding with s4U in some samples and s6G in others,
then performing standard nucleotide recoding chemistry, you will include
\code{tl_TC} and \code{tl_GA} columns corresponding to the s4U and s6G label times, respectively.
\item If a pulse-chase experimental design was used (!!this is strongly discouraged
unless you have a legitimate reason to prefer this design to a pulse-label
design!!), then you should have columns named \code{tpulse} and \code{tchase}, corresponding
to the pulse and chase times respectively. The same \verb{_<muttype>} convention should
be used in the case of multi-label pulse-chase designs.
}
\item sample characteristics: The remaining columns can be named whatever you like
and should include distinguishing features of groups of samples. Common columns might
include:
\itemize{
\item \code{treatment}: The experimental treatment applied to a set of samples.
This could represent things like genetic knockouts or knockdowns, drug treatments, etc.
\item \code{batch}: An ID for sets of samples that were collected and/or processed together.
Useful for regressing out technical batch effects
}

}}

\item{name}{Optional; name to give to fractions table.}

\item{character_limit}{Maximum number of characters for naming out fractions output. EZbakR
will try to name this as a "_" separated character vector of all of the features analyzed.
If this name is greater than \code{character_limit}, then it will default to "fraction#", where
"#" represents a simple numerical ID for the table.}
}
\value{
An EZbakRFractions object. This is simply a list of the provide \code{fractions} and
\code{metadf} with class \code{EZbakRFractions}
}
\description{
\code{EZbakRFractions} creates an object of class \code{EZbakRFractions} and checks the validity
of the provided input.
}
\examples{

# Simulate data
simdata <- EZSimulate(30)

# Get fractions table by estimating (for demonstration)
ezbdo <- EZbakRData(simdata$cB, simdata$metadf)
ezbdo <- EstimateFractions(ezbdo)
fxns <- EZget(ezbdo, type = "fractions")

# Create EZbakRFractions object
ezbfo <- EZbakRFractions(fxns, simdata$metadf)

}
