% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.evaluate.core.R
\name{diversity.evaluate.core}
\alias{diversity.evaluate.core}
\title{Diversity Indices}
\usage{
diversity.evaluate.core(
  data,
  names,
  qualitative,
  selected,
  base = 2,
  R = 1000,
  na.omit = TRUE
)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{base}{The logarithm base to be used for computation of Shannon-Weaver
Diversity Index (\mjseqn{I}). Default is 2.}

\item{R}{The number of bootstrap replicates. Default is 1000.}

\item{na.omit}{logical. If \code{TRUE}, missing values (\code{NA}) are
ignored and not included as a distinct factor level for computation.
Default is \code{TRUE}.}
}
\value{
A list with three data frames as follows. \item{simpson}{
  \describe{\item{Trait}{The qualitative trait.}
  \item{EC_No.Classes}{The number of classes in the trait for EC.}
  \item{CS_No.Classes}{The number of classes in the trait for CS.}
  \item{EC_d}{The Simpson's Index (\mjseqn{d}) for EC.}
  \item{EC_D}{The Simpson's Index of Diversity (\mjseqn{D}) for EC.}
  \item{EC_D.max}{The Maximum Simpson's Index of Diversity
  (\mjseqn{D_{max}}) for EC.} \item{EC_D.inv}{The Simpson's Reciprocal
  Index (\mjseqn{D_{R}}) for EC.} \item{EC_D.rel}{The Relative
  Reciprocal Index (\mjseqn{D'}) for EC.} \item{EC_d.V}{The variance
  of \mjseqn{d} for EC according to
  \insertCite{simpson_measurement_1949}{EvaluateCore}.}
  \item{EC_d.boot.V}{The bootstrap variance of \mjseqn{d} for EC.}
  \item{CS_d}{The Simpson's Index (\mjseqn{d}) for CS.}
  \item{CS_D}{The Simpson's Index of Diversity (\mjseqn{D}) for CS.}
  \item{CS_D.max}{The Maximum Simpson's Index of Diversity
  (\mjseqn{D_{max}}) for CS.} \item{CS_D.inv}{The Simpson's Reciprocal
  Index (\mjseqn{D_{R}}) for CS.} \item{CS_D.rel}{The Relative
  Reciprocal Index (\mjseqn{D'}) for CS.} \item{CS_d.V}{The variance
  of \mjseqn{d} for CS according to
  \insertCite{simpson_measurement_1949}{EvaluateCore}.}
  \item{CS_d.boot.V}{The bootstrap variance of \mjseqn{d} for CS.}
  \item{d.t.df}{The degrees of freedom for t test.}
  \item{d.t.stat}{The t statistic.} \item{d.t.pvalue}{The p
  value for t test.} \item{d.t.significance}{The  significance of t
  test for t-test} \item{d.boot.z.df}{The degrees of freedom for
  bootstrap z score.} \item{d.boot.z.stat}{The bootstrap z score.}
  \item{d.boot.z.pvalue}{The p value of z score.}
  \item{d.boot.z.significance}{The significance of z score.}} }
  \item{shannon}{ \describe{\item{Trait}{The qualitative
  trait.} \item{EC_No.Classes}{The number of classes in the trait for
  EC.} \item{CS_No.Classes}{The number of classes in the trait for
  CS.} \item{EC_I}{The Shannon-Weaver Diversity Index (\mjseqn{I}) for
  EC.} \item{EC_I.max}{The Maximum Shannon-Weaver Diversity Index
  (\mjseqn{I_{max}}) for EC.} \item{EC_I.rel}{The Relative
  Shannon-Weaver Diversity Index (\mjseqn{I'}) for EC.}
  \item{EC_I.V}{The variance of \mjseqn{I} for EC according to
  \insertCite{hutcheson_test_1970}{EvaluateCore}.}
  \item{EC_I.boot.V}{The bootstrap variance of \mjseqn{I} for EC.}
  \item{CS_I}{The Shannon-Weaver Diversity Index (\mjseqn{I}) for CS.}
  \item{CS_I.max}{The Maximum Shannon-Weaver Diversity Index
  (\mjseqn{I_{max}}) for CS.} \item{CS_I.rel}{The Relative
  Shannon-Weaver Diversity Index (\mjseqn{I'}) for CS.}
  \item{CS_I.V}{The variance of \mjseqn{I} for CS according to
  \insertCite{hutcheson_test_1970}{EvaluateCore}.}
  \item{CS_I.boot.V}{The bootstrap variance of \mjseqn{I} for CS.}
  \item{I.t.stat}{The t statistic.} \item{I.t.df}{The degrees
  of freedom for t test.} \item{I.t.pvalue}{The p value for t test.}
  \item{I.t.significance}{The  significance of t test for t-test}
  \item{I.boot.z.df}{The degrees of freedom for bootstrap z score.}
  \item{I.boot.z.stat}{The bootstrap z score.}
  \item{I.boot.z.pvalue}{The p value of z score.}
  \item{I.boot.z.significance}{The significance of z score.}} }
  \item{mcintosh}{ \describe{\item{EC_No.Classes}{The number of
  classes in the trait for EC.} \item{CS_No.Classes}{The number of
  classes in the trait for CS.} \item{EC_D.Mc}{The McIntosh Index
  (\mjseqn{D_{Mc}}) for EC.} \item{CS_D.Mc}{The McIntosh Index
  (\mjseqn{D_{Mc}}) for CS.} \item{M.boot.z.stat}{The bootstrap z
  score.} \item{M.boot.z.df}{The degrees of freedom for bootstrap z
  score.} \item{M.boot.z.pvalue}{The p value of z score.}
  \item{M.boot.z.significance}{The significance of z score.}} }
}
\description{
Compute the following diversity indices and perform corresponding statistical
tests to compare the phenotypic diversity for qualitative traits between
entire collection (EC) and core set (CS). \itemize{ \item{Simpson's and
related indices} \itemize{ \item{Simpson's Index (\mjseqn{d})
\insertCite{simpson_measurement_1949,peet_measurement_1974}{EvaluateCore}}
\item{Simpson's Index of Diversity or Gini's Diversity Index or Gini-Simpson
Index or Nei's Diversity Index or Nei's Variation Index (\mjseqn{D})
\insertCite{gini_variabilita_1912,gini_variabilita_1912-2,greenberg_measurement_1956,berger_diversity_1970,nei_analysis_1973,peet_measurement_1974}{EvaluateCore}}
\item{Maximum Simpson's Index of Diversity or Maximum Nei's
Diversity/Variation Index (\mjseqn{D_{max}})
\insertCite{hennink_interpretation_1990}{EvaluateCore}} \item{Simpson's
Reciprocal Index or Hill's \mjseqn{N_{2}} (\mjseqn{D_{R}})
\insertCite{williams_patterns_1964,hill_diversity_1973}{EvaluateCore}}
\item{Relative Simpson's Index of Diversity or Relative Nei's
Diversity/Variation Index (\mjseqn{D'})
\insertCite{hennink_interpretation_1990}{EvaluateCore}} }
\item{Shannon-Weaver and related indices} \itemize{ \item{Shannon or
Shannon-Weaver or Shannon-Weiner Diversity Index (\mjseqn{H})
\insertCite{shannon_mathematical_1949,peet_measurement_1974}{EvaluateCore}}
\item{Maximum Shannon-Weaver Diversity Index (\mjseqn{H_{max}})
\insertCite{hennink_interpretation_1990}{EvaluateCore}} \item{Relative
Shannon-Weaver Diversity Index or Shannon Equitability Index (\mjseqn{H'})
\insertCite{hennink_interpretation_1990}{EvaluateCore}} } \item{McIntosh
Diversity Index} \itemize{ \item{McIntosh Diversity Index (\mjseqn{D_{Mc}})
\insertCite{mcintosh_index_1967,peet_measurement_1974}{EvaluateCore}} } }
}
\section{Details}{
 The diversity indices and the corresponding statistical
  tests implemented in \code{diversity.evaluate.core} are as follows.

  \subsection{Simpson's and related indices}{Simpson's index (\mjseqn{d})
  which estimates the probability that two accessions randomly selected will
  belong to the same phenotypic class of a trait, is computed as follows
  \insertCite{simpson_measurement_1949,peet_measurement_1974}{EvaluateCore}.

  \mjsdeqn{d = \sum_{i = 1}^{k}p_{i}^{2}}

  Where, \mjseqn{p_{i}} denotes the proportion/fraction/frequency of
  accessions in the \mjseqn{i}th phenotypic class for a trait and \mjseqn{k}
  is the number of phenotypic classes for the trait.

  The value of \mjseqn{d} can range from 0 to 1 with 0 representing maximum
  diversity and 1, no diversity.

  \mjseqn{d} is subtracted from 1 to give Simpson's index of diversity
  (\mjseqn{D})
  \insertCite{greenberg_measurement_1956,berger_diversity_1970,peet_measurement_1974,hennink_interpretation_1990}{EvaluateCore}
   originally suggested by
  \insertCite{gini_variabilita_1912,gini_variabilita_1912-2;textual}{EvaluateCore}
   and described in literature as Gini's diversity index or Gini-Simpson
  index. It is the same as Nei's diversity index or Nei's variation index
  \insertCite{nei_analysis_1973,hennink_interpretation_1990}{EvaluateCore}.
  Greater the value of \mjseqn{D}, greater the diversity with a range from 0
  to 1.

  \mjsdeqn{D = 1 - d}

  The maximum value of \mjseqn{D}, \mjseqn{D_{max}} occurs when accessions
  are uniformly distributed across the phenotypic classes and is computed as
  follows \insertCite{hennink_interpretation_1990}{EvaluateCore}.

  \mjsdeqn{D_{max} = 1 - \frac{1}{k}}

  Reciprocal of \mjseqn{d} gives the Simpson's reciprocal index
  (\mjseqn{D_{R}})
  \insertCite{williams_patterns_1964,hennink_interpretation_1990}{EvaluateCore}
   and can range from 1 to \mjseqn{k}. This was also described in
  \insertCite{hill_diversity_1973;textual}{EvaluateCore} as (\mjseqn{N_{2}}).

  \mjsdeqn{D_{R} = \frac{1}{d}}

  Relative Simpson's index of diversity or Relative Nei's diversity/variation
  index (\mjseqn{H'}) \insertCite{hennink_interpretation_1990}{EvaluateCore}
  is defined as follows \insertCite{peet_measurement_1974}{EvaluateCore}.

  \mjsdeqn{D' = \frac{D}{D_{max}}}

  Differences in Simpson's diversity index for qualitative traits of EC and
  CS can be tested by a t-test using the associated variance estimate
  described in \insertCite{simpson_measurement_1949;textual}{EvaluateCore}
  \insertCite{lyons_c20_1978}{EvaluateCore}.

  The t statistic is computed as follows.

  \mjsdeqn{t = \frac{d_{EC} - d_{CS}}{\sqrt{V_{d_{EC}} + V_{d_{CS}}}}}

  Where, the variance of \mjseqn{d} (\mjseqn{V_{d}}) is,

  \mjsdeqn{V_{d} = \frac{4N(N-1)(N-2)\sum_{i=1}^{k}(p_{i})^{3} +
  2N(N-1)\sum_{i=1}^{k}(p_{i})^{2} - 2N(N-1)(2N-3) \left(
  \sum_{i=1}^{k}(p_{i})^{2} \right)^{2}}{[N(N-1)]^{2}}}

  The associated degrees of freedom is computed as follows.

  \mjsdeqn{df = (k_{EC} - 1) + (k_{CS} - 1)}

  Where, \mjseqn{k_{EC}} and \mjseqn{k_{CS}} are the number of phenotypic
  classes in the trait for EC and CS respectively.

  }

  \subsection{Shannon-Weaver and related indices}{An index of information
  \mjseqn{H}, was described by
  \insertCite{shannon_mathematical_1949;textual}{EvaluateCore} as follows.

  \mjsdeqn{H = -\sum_{i=1}^{k}p_{i} \log_{2}(p_{i})}

  \mjseqn{H} is described as Shannon or Shannon-Weaver or Shannon-Weiner
  diversity index in literature.

  Alternatively, \mjseqn{H} is also computed using natural logarithm instead
  of logarithm to base 2.

  \mjsdeqn{H = -\sum_{i=1}^{k}p_{i} \ln(p_{i})}

  The maximum value of \mjseqn{H} (\mjseqn{H_{max}}) is \mjseqn{\ln(k)}. This
  value occurs when each phenotypic class for a trait has the same proportion
  of accessions.

  \mjsdeqn{H_{max} = \log_{2}(k)\;\; \textrm{OR} \;\; H_{max} = \ln(k)}

  The relative Shannon-Weaver diversity index or Shannon equitability index
  (\mjseqn{H'}) is the Shannon diversity index (\mjseqn{I}) divided by the
  maximum diversity (\mjseqn{H_{max}}).

  \mjsdeqn{H' = \frac{H}{H_{max}}}

  Differences in Shannon-Weaver diversity index for qualitative traits of EC
  and CS can be tested by Hutcheson t-test
  \insertCite{hutcheson_test_1970}{EvaluateCore}.

  The Hutcheson t statistic is computed as follows.

  \mjsdeqn{t = \frac{H_{EC} - H_{CS}}{\sqrt{V_{H_{EC}} + V_{H_{CS}}}}}

  Where, the variance of \mjseqn{H} (\mjseqn{V_{H}}) is,

  \mjsdeqn{V_{H} = \frac{\sum_{i=1}^{k}n_{i}(\log_{2}{n_{i}})^{2}
  \frac{(\sum_{i=1}^{k}\log_{2}{n_{i}})^2}{N}}{N^{2}}}

  \mjsdeqn{\textrm{OR}}

  \mjsdeqn{V_{H} = \frac{\sum_{i=1}^{k}n_{i}(\ln{n_{i}})^{2}
  \frac{(\sum_{i=1}^{k}\ln{n_{i}})^2}{N}}{N^{2}}}

  The associated degrees of freedom is approximated as follows.

  \mjsdeqn{df = \frac{(V_{H_{EC}} +
  V_{H_{CS}})^{2}}{\frac{V_{H_{EC}}^{2}}{N_{EC}} +
  \frac{V_{H_{CS}}^{2}}{N_{CS}}}}

  }

  \subsection{McIntosh Diversity Index}{A similar index of diversity was
  described by \insertCite{mcintosh_index_1967;textual}{EvaluateCore} as
  follows (\mjseqn{D_{Mc}}) \insertCite{peet_measurement_1974}{EvaluateCore}.

  \mjsdeqn{D_{Mc} = \frac{N - \sqrt{\sum_{i=1}^{k}n_{i}^2}}{N - \sqrt{N}}}

  Where, \mjseqn{n_{i}} denotes the number of accessions in the \mjseqn{i}th
  phenotypic class for a trait and \mjseqn{N} is the total number of
  accessions so that \mjseqn{p_{i} = {n_{i}}/{N}}.}

  \subsection{Testing for difference with bootstrapping}{Bootstrap statistics
  are employed to test the difference between the Simpson, Shannon-Weaver and
  McIntosh indices for  qualitative traits of EC and CS
  \insertCite{solow_simple_1993}{EvaluateCore}.

  If \mjseqn{I_{EC}} and \mjseqn{I_{CS}} are the diversity indices with the
  original number of accessions, then random samples of the same size as the
  original are repeatedly generated (with replacement) \mjseqn{R} times and
  the corresponding diversity index is computed for each sample.

  \mjsdeqn{I_{EC}^{*} = \lbrace H_{EC_{1}}, H_{EC_{}}, \cdots, H_{EC_{R}}
  \rbrace}

  \mjsdeqn{I_{CS}^{*} = \lbrace H_{CS_{1}}, H_{CS_{}}, \cdots, H_{CS_{R}}
  \rbrace}

  Then the bootstrap null sample {\mjseqn{I_{0}}} is computed as follows.

  \mjsdeqn{\Delta^{*} = I_{EC}^{*} - I_{CS}^{*}}

  \mjsdeqn{I_{0} = \Delta^{*} - \overline{\Delta^{*}}}

  Where, \mjseqn{\overline{\Delta^{*}}} is the mean of \mjseqn{\Delta^{*}}.

  Now the original difference in diversity indices (\mjseqn{\Delta_{0} =
  I_{EC} - I_{CS}}) is tested against mean of bootstrap null sample
  (\mjseqn{I_{0}}) by a z test. The z score test statistic is computed as
  follows.

  \mjsdeqn{z = \frac{\Delta_{0} - \overline{H_{0}}}{\sqrt{V_{H_{0}}}}}

  Where,  \mjseqn{\overline{H_{0}}} and \mjseqn{V_{H_{0}}} are the mean and
  variance of the bootstrap null sample \mjseqn{H_{0}}.

  The corresponding degrees of freedom is estimated as follows.

  \mjsdeqn{df = (k_{EC} - 1) + (k_{CS} - 1)}

  }
}

\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

\donttest{
diversity.evaluate.core(data = ec, names = "genotypes",
                        qualitative = qual, selected = core)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[psych:misc]{shannon}}, \code{\link[vegan]{diversity}},
  \code{\link[boot]{boot}}
}
