% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_series.R
\name{import_series}
\alias{import_series}
\title{Import \code{EViews} series objects(s) into R, R Markdown or Quarto.}
\usage{
import_series(wf = "", page = "*", series = "*", class = "df")
}
\arguments{
\item{wf}{Object or a character string representing the name of a workfile to be created}

\item{page}{Object or a character string representing the name of a workfile page to be created}

\item{series}{Name(s) of \code{EViews} series object(s) in an \code{EViews} workfile}

\item{class}{Class of the R object: \code{df} for dataframe, or \code{xts} for extendable time-series object.}
}
\value{
An EViews workfile
}
\description{
Use this function to import \code{EViews} series objects(s) into R, R Markdown or Quarto as dataframe or \code{xts} object.
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

# To import all series objects across all pages

import_series(wf="exec_commands")

# Plot the dataframe object

library(ggplot2)

ggplot(eviews$eviewspage,aes(x=date))+geom_line(aes(y=x,color="x"))+
geom_line(aes(y=y,color="y"))+labs(colour='',x="",y="")

# To import all series objects across all pages, as an `xts` object

import_series(wf="exec_commands",class="xts")

# Plot the `xts` object

autoplot(eviews$eviewspage,facet='')+xlab("")

# To import specific series objects, for example starting with Y

import_series(wf="exec_commands",series="y*")

# To import series objects on specific pages

import_series(wf="exec_commands",page="eviewspage")


# To access the series in base R

eviews$eviewspage \%>\% head()

# To get the values above in R Markdown or Quarto:

# chunkLabel$eviewspage

}
}
\seealso{
Other important functions: 
\code{\link{EviewsR-package}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{export_dataframe}()},
\code{\link{import}()},
\code{\link{import_equation}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_table}()},
\code{\link{import_workfile}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
