#  ForCausality - A Curated Collection of Causal Inference Datasets and Tools
# Version 0.1.0
# Copyright (C) 2025 Tomás Valderrama
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.


library(testthat)

# Test 1: Confirm the object is a tibble and data.frame
test_that("Gbsg_df is a data.frame (tibble optional)", {
  expect_s3_class(Gbsg_df, "data.frame")
})

# Test 2: Confirm it has exactly 11 columns
test_that("Gbsg_df has 11 columns", {
  expect_equal(length(Gbsg_df), 11)
})

# Test 3: Confirm it has exactly 686 rows
test_that("Gbsg_df has 686 rows", {
  expect_equal(nrow(Gbsg_df), 686)
})

# Test 4: Confirm column names are correct
test_that("Gbsg_df has correct column names", {
  expect_named(Gbsg_df, c(
    "pid", "age", "meno", "size", "grade", "nodes", "pgr",
    "er", "hormon", "rfstime", "status"
  ))
})

# Test 5: Confirm column types are as expected
test_that("Gbsg_df columns have correct types", {
  expect_type(Gbsg_df$pid, "integer")
  expect_type(Gbsg_df$age, "integer")
  expect_type(Gbsg_df$meno, "integer")
  expect_type(Gbsg_df$size, "integer")
  expect_type(Gbsg_df$grade, "integer")
  expect_type(Gbsg_df$nodes, "integer")
  expect_type(Gbsg_df$pgr, "integer")
  expect_type(Gbsg_df$er, "integer")
  expect_type(Gbsg_df$hormon, "integer")
  expect_type(Gbsg_df$rfstime, "integer")
  expect_type(Gbsg_df$status, "integer")
})
