% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodsComparison.R
\name{MethodsComparison}
\alias{MethodsComparison}
\title{Comparison of imputation methods for fuzzy values.}
\usage{
MethodsComparison(
  trueData,
  iterations = 100,
  percentage = 0.05,
  trapezoidal = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{trueData}{Name of the input matrix (or data frame) with the true values of the variables.}

\item{iterations}{Number of the repetitions of each analyses (introducing NAs and then imputation of the missing values).}

\item{percentage}{Desired percentage of missing values (NAs) in each row.}

\item{trapezoidal}{Logical value depending on the type of fuzzy values (triangular or trapezoidal ones) in the dataset.}

\item{verbose}{Logical value if the progress bar should be shown.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is an S3 object of the class \code{metComp} given as a list of the matrices: 
\code{nonFNNumbers} - the vector with the numbers of non-FNs samples for each variable (with the overall mean),
\code{errorMatrix} -- the output from the function \code{ErrorMatrix},
\code{statisticalMeasures} -- the output from the function \code{StatisticalMeasures}, 
 \code{statisticalTests} -- the output from the function \code{ApplyStatisticalTests}, 
\code{fuzzyMeasures} -- the output from the function \code{CalculateFuzzyMeasures}.
}
\description{
`MethodsComparison` compares the quality of built-in imputation methods using various measures and goodness-of-fit statistical tests
 for the given fuzzy dataset.
}
\details{
The procedure uses the function \code{ImputationTests} to compare the quality of the imputation methods for the specified fuzzy dataset.
To minimize random effects, each analysis is repeated \code{iterations} times with the new randomly generated NA values
in the input dataset, and then new imputed values for all built-in methods.
To generate the new NAs values, the function \code{IntroducingNA} is used.
Next, the results, the same as for\code{ImputationTests} (apart from \code{trueValues} and \code{mask}), are averaged and their standard errors calculated (see the column \code{se}).

The input dataset can be given as matrix or data frame.

To get overall comparison of the methods, \code{summary(object,...)} can be used for the output object from this method.
The values \code{diff} are equal to the differences of p-values between the respective tests for the parts
\code{true} and \code{imputed} there.
}
\examples{

# seed PRNG

set.seed(1234)

# load the necessary library

library(FuzzySimRes)

# generate sample of trapezoidal fuzzy numbers with FuzzySimRes library

list1<-SimulateSample(20,originalPD="rnorm",parOriginalPD=list(mean=0,sd=1),
incrCorePD="rexp", parIncrCorePD=list(rate=2),
suppLeftPD="runif",parSuppLeftPD=list(min=0,max=0.6),
suppRightPD="runif", parSuppRightPD=list(min=0,max=0.6),
type="trapezoidal")

# convert fuzzy data into a matrix

matrix1 <- FuzzyNumbersToMatrix(list1$value)

# check starting values

head(matrix1)


# check the quality of the imputed values

\dontrun{

MethodsComparison(matrix1,iterations=10,trapezoidal=TRUE)

}

}
\seealso{
\code{\link{ImputationTests} for the single imputation benchmark, \link{summary.metComp}}.
}
