% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_knots.R
\name{splineX}
\alias{splineX}
\title{Build spline design matrices (piecewise polynomials, natural cubic, B-spline)}
\usage{
splineX(
  x,
  knots,
  degree = NULL,
  type = c("ppolys", "ns", "bs"),
  intercept = TRUE
)
}
\arguments{
\item{x}{Numeric vector of predictor values.}

\item{knots}{Numeric vector of interior knots.}

\item{degree}{Integer polynomial degree for \code{"ppolys"} and \code{"bs"}.
Ignored for \code{"ns"} (always cubic). Must be provided for
\code{"ppolys"} and \code{"bs"}.}

\item{type}{One of \code{c("ppolys", "ns", "bs")}.}

\item{intercept}{Logical; include intercept column where applicable. Default: `TRUE`.}
}
\value{
A numeric design matrix. Attributes are attached:
  \itemize{
    \item \code{"knots"} — the interior knots used
    \item \code{"boundary"} — \code{range(x)}
    \item \code{"degree"} — effective degree (i.e., 3 for \code{"ns"})
    \item \code{"type"} — the requested spline type
  }
}
\description{
Unified wrapper to generate spline covariates for three common cases:
\itemize{
  \item \code{type = "ppolys"}: Degree-\eqn{d} regression spline via
        truncated-power **piecewise polynomials** (uses internal \code{tp_basis()}).
  \item \code{type = "ns"}: Degree-3 **natural cubic spline**; enforces
        \eqn{f''(a)=f''(b)=0} at the boundary.
  \item \code{type = "bs"}: Degree-\eqn{d} **B-spline** basis (unconstrained).
}
}
\details{
Knots are sorted, no-duplicated, and any knots outside \code{range(x)} are
dropped with a warning. For \code{type = "ns"}, \code{degree} is ignored
(natural splines are cubic).
}
\examples{
set.seed(1)
x <- sort(rnorm(100))
k <- quantile(x, probs = c(.25, .5, .75))

# 1) Piecewise polynomials (degree 3)
X_pp <- splineX(x, knots = k, degree = 3, type = "ppolys", intercept = TRUE)
dim(X_pp) # n x ((3+1) + 3) = n x 7

# 2) Natural cubic spline (cubic, degree ignored)
X_ns <- splineX(x, knots = k, type = "ns", intercept = TRUE)

# 3) B-spline basis (degree 3)
X_bs <- splineX(x, knots = k, degree = 3, type = "bs", intercept = TRUE)

# Fit without a duplicated intercept:
# fit <- lm(y ~ 0 + X_pp)

}
\seealso{
\code{\link[splines]{bs}}, \code{\link[splines]{ns}}
}
