% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_kinetics.R
\name{calculate_kinetics}
\alias{calculate_kinetics}
\title{Calculate kinetics data}
\usage{
calculate_kinetics(
  dat,
  protein = dat[["Protein"]][1],
  sequence = dat[["Sequence"]][1],
  state = dat[["State"]][1],
  start = dat[["Start"]][1],
  end = dat[["End"]][1],
  time_0 = min(dat[["Exposure"]]),
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{dat data imported by the \code{\link{read_hdx}} function.}

\item{protein}{protein chosen protein.}

\item{sequence}{sequence of chosen peptide.}

\item{state}{biological state of chosen peptide.}

\item{start}{start position of chosen peptide.}

\item{end}{end position of chosen peptide.}

\item{time_0}{minimal exchange control time point of measurement.}

\item{time_100}{maximal exchange control time point of measurement.}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculate kinetics of the hydrogen-deuteration exchange 
for given peptide in given state.
}
\details{
The function calculates deuteration data for all available data points 
for given peptide in chosen biological state.. 
All four variants (relative & theoretical combinations) of deuterium uptake computations 
are supported. Manual correction of percentage of deuterium the protein was exposed 
to during the exchange in theoretical calculations is provided.
To visualize obtained data we recommend using \code{\link{plot_uptake_curve}} function.
The first version doesn't support filled Modification and Fragment columns.
IMPORTANT! The kinetic data is often described as deuterium uptake curve data. 
We use this terms interchangeable.
}
\examples{
# by default: for the first peptide
calculate_kinetics(alpha_dat)
       
}
\seealso{
\code{\link{read_hdx}} 
\code{\link{calculate_state_uptake}} 
\code{\link{plot_uptake_curve}}
}
