% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_sspde.R
\name{cgeneric_sspde}
\alias{cgeneric_sspde}
\title{Define the stationary SPDE cgeneric model for INLA.}
\usage{
cgeneric_sspde(mesh, alpha, control.priors, constr = FALSE, ...)
}
\arguments{
\item{mesh}{triangulation mesh to discretize the model.}

\item{alpha}{integer used to compute the smoothness parameter.}

\item{control.priors}{named list with parameter priors.
This shall contain \code{prange} and \code{psigma} each one
as a length two vector with (U, a) to define the PC-prior
parameters such that P(range<U)=a and P(sigma>U)=a, respectively.
See Fuglstad et. al. (2019) <DOI: 10.1080/01621459.2017.1415907>.
If a=0 or a=NA, then U is taken to be the fixed
value of the parameter.}

\item{constr}{logical, default is FALSE, to indicate if the
integral of the field over the domain is to be constrained to zero.}

\item{...}{additional arguments that will be passed on to
\code{\link[INLAtools:cgeneric-class]{INLAtools::cgenericBuilder()}}, such as:
\code{debug} : logical/integer, default is FALSE/0.
\code{useINLAprecomp} logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.}
}
\value{
objects to be used in the f() formula term in INLA.
}
\description{
Define the stationary SPDE cgeneric model for INLA.
}
\note{
This is the stationary case of \code{\link[INLA:inla.spde2.pcmatern]{INLA::inla.spde2.pcmatern()}}
with slight change on the marginal variance when the domain is
the sphere, following Eq. (23) in Lindgren et. al. (2024).
}
\references{
Geir-Arne Fuglstad, Daniel Simpson, Finn Lindgren & Håvard Rue (2019).
Constructing Priors that Penalize the Complexity of Gaussian Random Fields.
Journal of the American Statistical Association, V. 114, Issue 525.

Finn Lindgren, Haakon Bakka, David Bolin, Elias Krainski and Håvard Rue (2024).
A diffusion-based spatio-temporal extension of Gaussian Matérn fields.
\href{https://raco.cat/index.php/SORT/article/view/428665}{SORT vol.  48, no. 1, pp. 3-66}
<doi: 10.57645/20.8080.02.13>
}
