% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inlavaan.R
\name{acfa}
\alias{acfa}
\title{Fit an Approximate Bayesian Confirmatory Factor Analysis Model}
\usage{
acfa(
  model,
  data,
  dp = blavaan::dpriors(),
  marginal_method = c("skewnorm", "asymgaus", "marggaus", "sampling"),
  nsamp = 500,
  test = "standard",
  marginal_correction = c("shortcut", "hessian", "none"),
  sn_fit_logthresh = -6,
  sn_fit_temp = NA,
  control = list(),
  verbose = TRUE,
  debug = FALSE,
  add_priors = TRUE,
  optim_method = c("nlminb", "ucminf", "optim"),
  numerical_grad = FALSE,
  ...
)
}
\arguments{
\item{model}{A description of the user-specified model. Typically, the model
    is described using the lavaan model syntax. See 
    \code{\link[lavaan]{model.syntax}} for more information. Alternatively, a
    parameter table (eg. the output of the \code{lavParTable()} function) is also
    accepted.}

\item{data}{An optional data frame containing the observed variables used in
    the model. If some variables are declared as ordered factors, lavaan will
    treat them as ordinal variables.}

\item{dp}{Default prior distributions on different types of
    parameters, typically the result of a call to \code{dpriors()}.
    See the \code{dpriors()} help file for more information.}

\item{marginal_method}{The method for approximating the marginal posterior
distributions. Options include \code{"skewnorm"} (skew normal), \code{"asymgaus"}
(two-piece asymmetric Gaussian), \code{"marggaus"} (marginalising the Laplace
approximation), and \code{"sampling"} (sampling from the joint Laplace
approximation).}

\item{nsamp}{The number of samples to draw for all sampling-based approaches
(including posterior sampling for model fit indices).}

\item{test}{Character indicating whether to compute posterior fit indices.
Defaults to "standard". Change to "none" to skip these computations.}

\item{marginal_correction}{Which type of correction to use when fitting the
skew normal or two-piece Gaussian marginals. \code{"hessian"} computes the full
Hessian-based correction (slow), \code{"shortcut"} (default) computes only
diagonals, and \code{"none"} (or \code{FALSE}) applies no correction.}

\item{sn_fit_logthresh}{The log-threshold for fitting the skew normal. Points
with log-posterior drop below this threshold (relative to the maximum) will
be excluded from the fit. Defaults to \code{-6}.}

\item{sn_fit_temp}{Temperature parameter for fitting the skew normal. If
\code{NA}, the temperature will be included in the optimisation during the skew
normal fit.}

\item{control}{A list of control parameters for the optimiser.}

\item{verbose}{Logical indicating whether to print progress messages.}

\item{debug}{Logical indicating whether to return debug information.}

\item{add_priors}{Logical indicating whether to include prior densities in
the posterior computation.}

\item{optim_method}{The optimisation method to use for finding the posterior
mode. Options include \code{"nlminb"} (default), \code{"ucminf"}, and \code{"optim"}
(BFGS).}

\item{numerical_grad}{Logical indicating whether to use numerical gradients
for the optimisation.}

\item{...}{Additional arguments to be passed to the \link[lavaan:lavaan]{lavaan::lavaan} model fitting
function.}
}
\value{
An S4 object of class \code{INLAvaan} which is a subclass of the
\link[lavaan:lavaan-class]{lavaan::lavaan} class.
}
\description{
Fit an Approximate Bayesian Confirmatory Factor Analysis Model
}
\details{
The \code{\link[=acfa]{acfa()}} function is a wrapper for the more general \code{\link[=inlavaan]{inlavaan()}}
function, using the following default arguments:
\itemize{
\item \code{int.ov.free = TRUE}
\item \code{int.lv.free = FALSE}
\item \code{auto.fix.first = TRUE} (unless \code{std.lv = TRUE})
\item \code{auto.fix.single = TRUE}
\item \code{auto.var = TRUE}
\item \code{auto.cov.lv.x = TRUE}
\item \code{auto.efa = TRUE}
\item \code{auto.th = TRUE}
\item \code{auto.delta = TRUE}
\item \code{auto.cov.y = TRUE}
}

For further information regarding these arguments, please refer to the
\code{\link[lavaan:lavOptions]{lavaan::lavOptions()}} documentation.
}
\examples{
# The famous Holzinger and Swineford (1939) example
HS.model <- "
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
"
utils::data("HolzingerSwineford1939", package = "lavaan")

# Fit a CFA model with standardised latent variables
fit <- acfa(HS.model, data = HolzingerSwineford1939, std.lv = TRUE, nsamp = 100)
summary(fit)
}
\seealso{
Typically, users will interact with the specific latent variable
model functions instead, including \code{\link[=acfa]{acfa()}}, \code{\link[=asem]{asem()}}, and \code{\link[=agrowth]{agrowth()}}.
}
