% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRT.test.Bootstrap.R
\name{LRT.test.Bootstrap}
\alias{LRT.test.Bootstrap}
\title{Bootstrap Likelihood Ratio Test}
\usage{
LRT.test.Bootstrap(object1, object2, n.Bootstrap = 100, vis = TRUE)
}
\arguments{
\item{object1}{Fitted model object with fewer parameters (i.e., fewer \code{npar}, small model).}

\item{object2}{Fitted model object with more parameters (i.e., more \code{npar}, large model).}

\item{n.Bootstrap}{Number of bootstrap replicates (default = 100). Higher values increase
accuracy but computation time (we suggest that \code{n.Bootstrap = 1000}).}

\item{vis}{Logical. If \code{TRUE}, displays progress information during bootstrap (default: \code{TRUE}).}
}
\value{
An object of class \code{"htest"} containing:
\itemize{
\item \code{statistic}: Observed likelihood ratio test statistic
\item \code{parameter}: Degrees of freedom (reported as \code{NA} since p-value is bootstrap-derived)
\item \code{p.value}: Bootstrap p-value
\item \code{method}: Name of the test ("Bootstrap Likelihood Ratio Test")
\item \code{data.name}: Model comparison description
}
}
\description{
Conducts a bootstrap likelihood ratio test to compare the fit of two nested models.
This test evaluates whether a model with more parameters provides a significantly
better fit than a model with fewer parameters by approximating the null distribution
through parametric bootstrapping.
}
\details{
Note that even the result of \code{\link[LCPA]{LRT.test.Bootstrap}} should not be taken as the sole
criterion; fit indices (e.g., \code{\link[LCPA]{get.fit.index}}) and classification accuracy
measures (e.g., \code{\link[LCPA]{get.entropy}}, \code{\link[LCPA]{get.AvePP}}) must be considered together.
Above all and the most important criterion, is that the better model is the one that aligns with theoretical
expectations and offers clear interpretability.

The \code{\link[LCPA]{LRT.test.Bootstrap}} statistic is calculated as:
\deqn{LRT = -2 \times (\text{LogLik}_{1} - \text{LogLik}_{2})}
where:
\itemize{
\item \eqn{\text{LogLik}_{1}}: Log-likelihood of the smaller model (fewer parameters).
\item \eqn{\text{LogLik}_{2}}: Log-likelihood of the larger model (more parameters).
}

The \code{\link[LCPA]{LRT.test.Bootstrap}} function employs a parametric bootstrap procedure to
empirically estimate the distribution of the LRT statistic under the null hypothesis (that the
smaller model is sufficient). The specific steps are as follows:
\enumerate{
\item Parameter Extraction: The estimated parameters (\code{params}) from the smaller model
(\code{object1}) are treated as the true population values (ground truth).
\item Data Simulation: The function invokes \code{\link[LCPA]{sim.LCA}} or \code{\link[LCPA]{sim.LPA}}
to generate \code{n.Bootstrap} independent datasets. Each dataset maintains the same sample size (\code{N})
and number of indicators (\code{I}) as the original empirical data.
\item Model Re-fitting: For each simulated dataset, both the small model and the large model are
re-fitted. To ensure consistency, the estimation settings (e.g., convergence criteria, iterations)
are identical to those used for the original models, with the exception that
\code{\link[LCPA]{LRT.test.Bootstrap}} forces \code{par.ini = "random"} to avoid local maxima.
\item Distribution Generation: This process generates \code{n.Bootstrap} pairs of
\eqn{\text{LogLik}_{1, boot}} and \eqn{\text{LogLik}_{2, boot}}, which are used to compute
a collection of bootstrap LRT statistics:
\eqn{LRT_{boot} = -2 \times (\text{LogLik}_{1, boot} - \text{LogLik}_{2, boot})}.
\item P-value Calculation: The bootstrap \eqn{p}-value is calculated as the proportion of
simulated \eqn{LRT_{boot}} values that are greater than or equal to the observed \eqn{LRT}
statistic from the original data.
}

This method is particularly recommended for Latent Class and Latent Profile Analysis because
the traditional Chi-square distribution for LRT often fails to hold due to parameters
being on the boundary of the parameter space (e.g., probabilities near 0 or 1).
}
