% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq2D_test.R
\name{chi_cont_test}
\alias{chi_cont_test}
\title{Chi-square test for 2D data}
\usage{
chi_cont_test(
  dta,
  pnull,
  phat = function(x) -99,
  Ranges = matrix(c(-Inf, Inf, -Inf, Inf), 2, 2),
  nbins = c(5, 5),
  minexpcount = 5,
  SuppressMessages = TRUE
)
}
\arguments{
\item{dta}{a matrix of numbers.}

\item{pnull}{function to calculate expected counts.}

\item{phat}{=function(x) -99, function to estimate parameters of pnull.}

\item{Ranges}{=matrix(c(-Inf, Inf, -Inf, Inf),2,2), a 2x2 matrix with lower and upper bounds}

\item{nbins}{=c(5,5) number of bins in x and y direction}

\item{minexpcount}{=5 minimum counts required per bin}

\item{SuppressMessages}{=FALSE, should info be shown?}
}
\value{
a matrix with statistics, p values and degree of freedoms
}
\description{
This function does the chi square goodness-of-fit test for continuous data in two dimensions.
}
