% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omega_partial_ss_rm.R
\name{omega_partial_ss_rm}
\alias{omega_partial_ss_rm}
\alias{omega.partial.SS.rm}
\title{omega^2_p (Partial Omega Squared) for Repeated Measures ANOVA from F}
\usage{
omega_partial_ss_rm(dfm, dfe, msm, mse, mss, ssm, sse, sss, a = 0.05)

omega.partial.SS.rm(dfm, dfe, msm, mse, mss, ssm, sse, sss, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{msm}{mean square for the model/IV/between}

\item{mse}{mean square for the error/residual/within}

\item{mss}{mean square for the subject variance}

\item{ssm}{sum of squares for the model/IV/between}

\item{sse}{sum of squares for the error/residual/within}

\item{sss}{sum of squares for the subject variance}

\item{a}{significance level}
}
\value{
\describe{
  \item{omega}{\eqn{\omega^2_p} effect size (legacy name; see also
`omega_value`)}
  \item{omegalow}{lower-level confidence interval of \eqn{\omega^2_p}
        (legacy name; see also `omega_lower_limit`)}
  \item{omegahigh}{upper-level confidence interval of \eqn{\omega^2_p}
        (legacy name; see also `omega_upper_limit`)}
  \item{dfm}{degrees of freedom for the model/IV/between
        (legacy name; see also `df_model`)}
  \item{dfe}{degrees of freedom for the error/residual/within
        (legacy name; see also `df_error`)}
  \item{F}{\eqn{F}-statistic (legacy name; see also `f_value`)}
  \item{p}{p-value (legacy name; see also `p_value`)}
  \item{estimate}{the \eqn{\omega^2_p} statistic and confidence
interval in APA style for markdown printing}
  \item{statistic}{the \eqn{F}-statistic in APA style for markdown printing}
  \item{omega_value}{\eqn{\omega^2_p} effect size (snake_case alias
of `omega`)}
  \item{omega_lower_limit}{lower-level confidence interval of
\eqn{\omega^2_p} (alias of `omegalow`)}
  \item{omega_upper_limit}{upper-level confidence interval of
\eqn{\omega^2_p} (alias of `omegahigh`)}
  \item{df_model}{degrees of freedom for the model/IV/between
(alias of `dfm`)}
  \item{df_error}{degrees of freedom for the error/residual/within
(alias of `dfe`)}
  \item{f_value}{\eqn{F}-statistic (alias of `F`)}
  \item{p_value}{p-value (alias of `p`)}
}
}
\description{
This function displays \eqn{\omega^2_p} from ANOVA analyses
and its non-central confidence interval based on the \eqn{F} distribution.
This formula is appropriate for multi-way repeated measures designs
and mixed-level designs.
}
\details{
Partial omega squared is calculated by subtracting the mean
square for the error from the mean square of the model, which is
multiplied by degrees of freedom of the model. This is divided
by the sum of the sum of squares for the model, sum of squares
for the error, sum of squares for the subject, and the
mean square of the subject.

\deqn{\omega^2_p = \frac{df_m (MS_M - MS_E)}{SS_M + SS_E + SS_S + MS_S}}

The F-statistic is calculated by dividing the mean square
of the model by the mean square of the error.

     F = msm / mse

\href{https://www.aggieerin.com/shiny-server/tests/omegaprmss.html}{Learn more on our example page.}

**Note on function and output names:** This effect size is now implemented
with the snake_case function name `omega_partial_ss_rm()` to follow modern R
style guidelines. The original dotted version `omega.partial.SS.rm()` is
still available as a wrapper for backward compatibility, and both functions
return the same list. The returned object includes both the original element
names (e.g., `omega`, `omegalow`, `omegahigh`, `dfm`, `dfe`, `F`, `p`,
`estimate`, `statistic`) and newer snake_case aliases (e.g., `omega_value`,
`omega_lower_limit`, `omega_upper_limit`, `df_model`, `df_error`, `f_value`,
`p_value`). New code should prefer `omega_partial_ss_rm()` and the
snake_case output names, but existing code using the older names will
continue to work.
}
\examples{

# The following example is derived from the "rm2_data" dataset,
# included in the MOTE library.

# In this experiment people were given word pairs to rate based on
# their "relatedness". How many people out of a 100 would put LOST-FOUND
# together? Participants were given pairs of words and asked to rate them
# on how often they thought 100 people would give the second word if shown
# the first word.  The strength of the word pairs was manipulated through
# the actual rating (forward strength: FSG) and the strength of the reverse
# rating (backward strength: BSG). Is there an interaction between FSG and
# BSG when participants are estimating the relation between word pairs?

# You would calculate one partial GOS value for each F-statistic.
# You can leave out the MS options if you include all the SS options.
# Here's an example for the interaction with typing in numbers.
omega_partial_ss_rm(dfm = 1, dfe = 157,
                    msm = 2442.948 / 1,
                    mse = 5402.567 / 157,
                    mss = 76988.130 / 157,
                    ssm = 2442.948, sss = 76988.13,
                    sse = 5402.567, a = .05)

# Backwards-compatible dotted name (deprecated)
omega.partial.SS.rm(dfm = 1, dfe = 157,
                    msm = 2442.948 / 1,
                    mse = 5402.567 / 157,
                    mss = 76988.130 / 157,
                    ssm = 2442.948, sss = 76988.13,
                    sse = 5402.567, a = .05)
}
\keyword{ANOVA}
\keyword{effect}
\keyword{omega}
\keyword{size}
