\name{Log_LR_Test_Statistic}
\alias{Log_LR_Test_Statistic}
\title{
Compute Log-Likelihood Ratio test statistics for permutation based Extended Random Effect Maximal Interaction (E-ReMI) Two-Mode Clustering Model
}
\description{
Computes the log-likelihood ratio statistic used for hypothesis testing in the E-ReMI for Two-Mode Clustering model. 
The statistic compares the fitted model (some intercation) against a null model (no intercation).
}
\usage{
Log_LR_Test_Statistic(DC, I, J, initM, initOmega_hat)
}
\arguments{
  \item{DC}{
A numeric data matrix of size \code{I x J}, typically doubly centered, representing the two-mode data to be analyzed.
}
  \item{I}{
An integer specifying the number of rows (first mode entities) in the data matrix.
}
  \item{J}{
An integer specifying the number of columns (second mode entities) in the data matrix.
}
  \item{initM}{
The matrix M is reconstructed obtained via initial random row partition matrix (R), initial random column partition matrix (C) 
and initial bi-cluster interaction matrix (G) and it is updated after each updation of R, C and G. 
}
  \item{initOmega_hat}{
A numeric vector of estimated row cluster weights (proportions), summing to 1.
}
}
\details{
This function evaluates the log-likelihood ratio (LLR) test statistic by comparing the log-likelihood under the fitted model 
(presence of row by colum cluster intercation) to that of a baseline model with no intercation. The test statistic can be used 
in permutation-based inference procedures to assess significance of row by colum cluster intercation in two-mode data.
}
\value{
Returns a single numeric value:
  \item{Log_LR}{The value of the log-likelihood ratio test statistic.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
Used internally in permutation-based hypothesis testing procedures for the E-ReMI Two-Mode Clustering framework.
}
\seealso{
\code{\link{Permutation_Function}, \link{diag}, \link[pracma]{pinv}}
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2
DC <- matrix(rnorm(I*J), I, J)
R  <- diag(1, I, P)
C  <- diag(1, J, Q)
R_inv <- pracma::pinv(t(R) \%*\% R)
C_inv <- pracma::pinv(t(C) \%*\% C)
G <- R_inv \%*\% t(R) \%*\% DC \%*\% C \%*\% C_inv
initM <- R \%*\% G \%*\% t(C)
initOmega_hat <- c(0.5, rep((1-0.5)/P, P))
result <- Log_LR_Test_Statistic(DC, I, J, initM, initOmega_hat)
result
}
\keyword{E-ReMI based two-mode clustering}
\keyword{Permutation based hypothesis testing}
