% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_OLS.R
\name{Navae_ci_ols}
\alias{Navae_ci_ols}
\title{Compute NAVAE CI for coefficients of a linear regression based on
the OLS estimator and Berry-Esseen (BE) or Edgeworth Expansions (EE) bounds}
\usage{
Navae_ci_ols(
  Y,
  X,
  alpha = 0.05,
  a = NULL,
  omega = NULL,
  bounds = list(lambda_reg = NULL, K_reg = NULL, K_eps = NULL, K_xi = NULL, C = NULL, B =
    NULL),
  K_xi = NULL,
  param_BE_EE = list(choice = "best", setup = list(continuity = FALSE, iid = TRUE,
    no_skewness = FALSE), regularity = list(C0 = 1, p = 2), eps = 0.1),
  intercept = TRUE,
  options = list(center = FALSE, bounded_case = FALSE, with_Exp_regime = FALSE),
  matrix_u = NULL,
  verbose = 0
)
}
\arguments{
\item{Y}{vector of observations of the explained variables}

\item{X, intercept}{\code{X} is the matrix of explanatory variables. If
\code{intercept = TRUE}, a constant column of \code{1} (intercept) is added
too. Note that the number of rows of \code{X} must be the same as the length
of \code{Y}.}

\item{alpha}{this is 1 minus the confidence level of the CI; in other words,
the nominal level is 1 - alpha.
By default, \code{alpha} is set to 0.05, yielding a 95\% CI.}

\item{a}{the free parameter \eqn{a} (or \eqn{a_n}) of the interval.
It must be either \itemize{
  \item a numeric value larger than 1, taken as the value of \eqn{a},

  \item the character value \code{"best"} which is the default. It selects the
  \code{a} such that the confidence interval has the smallest length.

  \item a list such as \code{list(power_of_n_for_b = -2/5)} giving a way to
  compute \code{a} as \code{a = 1 + n^power_of_n_for_b}. Note that \code{-2/5}
  is the optimal (theoretical) rate.

  \item \code{NULL}, interpreted as the default value
  \code{a = 1 + 100 * n^(-2/5)}.
}}

\item{omega}{the free parameter \eqn{omega} (or \eqn{omega_n}) of the interval.
It must be either \itemize{
  \item a numeric value larger than 1, taken as the value of \eqn{omega},

  \item the character value \code{"best"} which is the default. It selects the
  \code{omega} such that the confidence interval has the smallest length.

  \item a list such as \code{list(power_of_n_for_omega = -1/5)} giving a way to
  compute \code{omega} as \code{omega = n^power_of_n_for_omega}.
  Note that \code{-1/5} is the optimal (theoretical) rate.

  \item \code{NULL}, interpreted as the default value
  \code{omega = n^(-1/5)}.
}}

\item{bounds, K_xi}{list of bounds for the DGP. Note that \code{K_xi} can also
be provided as a separate argument, for convenience.
It can contain the following items: \itemize{
   \item \code{lambda_reg}
   \item \code{K_eps}
   \item \code{K_xi}
   \item \code{K3_xi}
   \item \code{lambda3_xi}
   \item \code{K3tilde_xi}
   \item \code{B}, \code{C} Bounds for the concentration of || Xi tilde %*% Xi tilde'||
   \item \code{K_reg} Bound on
   \eqn{ E[ || vec( \widetilde{X}\widetilde{X}'- \mathbb{I}_p ) ||^2 ] }
   Defined in Assumption 3.2 (ii).
}
The bounds that are not given are replaced by plug-ins.
For K3_xi, lambda3_xi and K3tilde_xi, the bounds are obtained
from K_xi (= K4_xi).}

\item{param_BE_EE}{parameters to compute the BE or EE bound \eqn{\delta_n} used
to construct the confidence interval.
Otherwise, \code{param_BE_EE} is a list of four objects: \itemize{
  \item \code{choice}: \itemize{
     \item If equal to \code{"EE"}, the bound used is Derumigny et al. (2023)'s
     bound computed using the parameters specified by the rest of \code{param_BE_EE},
     as described in the arguments of the function
     \code{BoundEdgeworth::\link[BoundEdgeworth]{Bound_EE1}}.
     Together, these last three items of the list specify the bounds and
     assumptions used to compute the bound \eqn{\delta_n} from Derumigny et al. (2023).

     \item If equal to \code{"BE"}, then the bound used is the best up-to-date
     BE bound from Shevtsova (2013) combined with a convexity inequality.

     \item If equal to \code{"best"}, both bounds are computed
     and the smallest of both is used.

     By default, following Remark 3.3 of the article, \code{"best"} is used
     and Derumigny et al. (2023)'s bound is computed assuming i.i.d data and
     no other regularity assumptions (continuous or unskewed distribution).
     The bound on kurtosis that is used is the one specified in the previous
     argument \code{K_xi}.
  }

  \item \code{setup}: itself a logical vector of size 3,
  \item \code{regularity}: itself a list of length up to 3,
  \item \code{eps}: value between 0 and 1/3,
}}

\item{options}{a list of other options (experimental).}

\item{matrix_u}{each row of this matrix is understood as a new vector u
for which a confidence interval should be computed.
By default \code{matrix_u} is the identity matrix, corresponding
to the canonical basis of \eqn{R^p}.}

\item{verbose}{If \code{verbose = 0}, this function is silent and does not
print anything. Increasing values of \code{verbose} print more details about
the progress of the computations and, in particular, the different terms that
are computed.}
}
\value{
\code{Navae_ci_ols} returns an object of class \code{NAVAE_CI_OLS},
containing
\itemize{
  \item \code{ci_navae}: the NAVAE confidence interval

  \item \code{ci_asymp}: the classical "asymptotic" CI based on CLT
  (as a comparison)

  \item \code{allTuningParameters}, \code{allBounds}: information concerning
  the tuning parameters and the bounds used (numerical value and origin)

  \item \code{about_delta_n}, \code{delta_n_from}: respectively the numerical value
  of the bound \eqn{delta_n} used, and a character string \code{BE} or \code{EE}
  indicating which type of inequality was used.

  \item \code{minimal_alpha_to_exit_R_regime}: the minimal alpha to exit the
  \eqn{\mathbb{R}} regime.

  \item \code{bound_K_value}, \code{bound_K_method}: the value K used and the
  method to compute it.
}
}
\description{
Compute NAVAE CI for coefficients of a linear regression based on
the OLS estimator and Berry-Esseen (BE) or Edgeworth Expansions (EE) bounds
}
\examples{
n = 4000
X1 = rnorm(n, sd = 1)
true_eps = rnorm(n)
Y = 2 + 8 * X1 + true_eps

myCI <- Navae_ci_ols(Y, X1, K_xi = 3, a = 1.1)

print(myCI)



}
\references{
For the confidence interval:

Derumigny, A., Girard, L., & Guyonvarch, Y. (2025).
Can we have it all?
Non-asymptotically valid and asymptotically exact confidence intervals
for expectations and linear regressions.
ArXiv preprint, \doi{10.48550/arXiv.2507.16776}.

For the underlying Edgeworth expansion bounds:

Derumigny A., Girard L., and Guyonvarch Y. (2023).
Explicit non-asymptotic bounds for the distance to the first-order Edgeworth expansion,
Sankhya A. \doi{10.1007/s13171-023-00320-y}
ArXiv preprint: \doi{10.48550/arxiv.2101.05780}.
}
\seealso{
The methods to display and process the output of this function:
\code{\link{print.NAVAE_CI_OLS}} and
\code{\link{as.data.frame.NAVAE_CI_OLS}}.

\code{\link{Navae_ci_mean}} which is the corresponding function for the
estimation of the mean.
}
