#' Calculate N Balance Index of a System (sNBI)
#' @description
#' The accumulation or reduction of soil N over a set time.
#' Formula: sNBI = Ni - No - delSoilN
#' @param Ni Sum total of N inputs (vector or value).
#' @param No Sum total of N outputs (vector or value).
#' @param delSoilN Change in total soil N value.
#' @return A numeric vector of sNBI values.
#' @examples
#' Ni <- c(100, 120)
#' No <- c(80, 90)
#' delSoilN <- c(5, -2)
#' sNBI(Ni, No, delSoilN)
#' @export
sNBI <- function(Ni, No, delSoilN) {
  return(Ni - No - delSoilN)
}