test_that("FIM_mixture_normals returns a symmetric finite 5x5 matrix with names", {
  set.seed(1)
  data <- c(rnorm(200, -2, 1), rnorm(200, 2, 1))
  params <- list(pi = 0.4, mu1 = -2, mu2 = 2, sigma1 = 1, sigma2 = 1.2)

  fim <- FIM_mixture_normals(data, params)

  expect_true(is.matrix(fim))
  expect_equal(dim(fim), c(5, 5))
  expect_equal(colnames(fim), c("mu1", "mu2", "sigma1", "sigma2", "pi"))
  expect_equal(rownames(fim), c("mu1", "mu2", "sigma1", "sigma2", "pi"))

  expect_equal(fim, t(fim), tolerance = 1e-10)
  expect_true(all(is.finite(fim)))
})

test_that("FIM_mixture_normals is positive semidefinite (OPG property)", {
  set.seed(1)
  data <- c(rnorm(150, -1, 0.8), rnorm(150, 1, 1.1))
  params <- list(pi = 0.5, mu1 = -1, mu2 = 1, sigma1 = 0.8, sigma2 = 1.1)

  fim <- FIM_mixture_normals(data, params)

  # Eigenvalues of G'G should be >= 0 up to numerical tolerance
  ev <- eigen(fim, symmetric = TRUE, only.values = TRUE)$values
  expect_true(min(ev) >= -1e-8)
})
