% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdowns.R
\name{getEnrichmentsAnnotations}
\alias{getEnrichmentsAnnotations}
\title{Get the annotations for the enrichments of an installed OmicNavigator study}
\usage{
getEnrichmentsAnnotations(study, modelID, libraries = NULL)
}
\arguments{
\item{study}{An OmicNavigator study. Only accepts name of installed study
package.}

\item{modelID}{The modelID selected by the user in the app}

\item{libraries}{Character vector of library directories to search for study
packages. If \code{NULL}, uses \code{.libPaths}.}
}
\value{
A named list. The names are the identifiers to be displayed in the
dropdown menu, and each list element is a single character vector with the
description to be used as a tooltip in the app. If no custom description
was provided by the user, the tooltip text is simply the identifier.
}
\description{
This is the API endpoint the app uses to populate the dropdown menu in the
Enrichment Analysis tab with the list of available annotations for the
selected model and study.
}
\details{
The annotations correspond to those used when adding the enrichments with
\code{\link{addEnrichments}}. Any optional tooltips correspond to the
descriptions added with \code{\link{addAnnotations}}.
}
\seealso{
\code{\link{getEnrichmentsStudies}},
\code{\link{getEnrichmentsModels}},
\code{\link{addEnrichments}},
\code{\link{addAnnotations}}
}
