% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_obwoe.R
\name{obwoe_max_bins}
\alias{obwoe_max_bins}
\title{Maximum Bins Parameter}
\usage{
obwoe_max_bins(range = c(5L, 20L), trans = NULL)
}
\arguments{
\item{range}{A two-element integer vector specifying the minimum and maximum
values for the parameter. Default is \code{c(5L, 20L)}.}

\item{trans}{A transformation object from the \code{scales} package, or
\code{NULL} for no transformation. Default is \code{NULL}.}
}
\value{
A \code{dials} quantitative parameter object.
}
\description{
A quantitative tuning parameter for the maximum number of bins in
\code{\link{step_obwoe}}.
}
\details{
The maximum number of bins limits algorithm complexity and helps prevent
overfitting. Higher values allow more granular discretization but may
capture noise rather than signal.

For credit scoring applications, \code{max_bins} is typically set between
5 and 10 to balance predictive power with interpretability. Values above
15 are rarely necessary and may indicate overfitting.
}
\examples{
obwoe_max_bins()
obwoe_max_bins(range = c(4L, 12L))

}
\seealso{
\code{\link{step_obwoe}}, \code{\link{obwoe_min_bins}}
}
