% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_traits.R
\name{extract_traits}
\alias{extract_traits}
\title{Extract Plant Traits from Trait Database}
\usage{
extract_traits(sp.list, dataset, rank = "species", traits = NULL)
}
\arguments{
\item{sp.list}{A character vector containing the names of taxa to extract traits for.
The names should match the taxonomic rank specified in the 'rank' parameter.}

\item{dataset}{A data frame containing trait data. Default is TRY database.
Must contain columns named "species", "genus", and "family" for taxonomic information.}

\item{rank}{A character string specifying the taxonomic rank to match against.
Must be one of "species", "genus", or "family". Default is "species".}

\item{traits}{A character vector specifying which traits to extract. If NULL (default),
all available traits in the dataset will be extracted. Available traits are all
columns except "species", "genus", and "family".}
}
\value{
A data frame with taxa names as row names and trait names as column names.
  For species-level extraction, returns the first occurrence of each species.
  For genus/family-level extraction, returns mean values for numeric traits
  and the first occurrence for non-numeric traits. Missing values are represented as NA.
}
\description{
This function extracts plant trait data from the TRY database or similar datasets
for a specified list of taxa at different taxonomic ranks (species, genus, or family).
For numeric traits at genus and family levels, it calculates mean values across
all available records.
}
\details{
The function performs the following operations:
\itemize{
  \item Validates input parameters
  \item Identifies available traits in the dataset
  \item Matches input taxa with dataset entries
  \item Reports missing taxa
  \item Extracts trait data based on the specified taxonomic rank
  \item For numeric traits at genus/family level, calculates mean values
  \item For non-numeric traits, uses the first available value
  \item Handles NaN values by converting them to NA
}
}
\examples{
# Load the dataset
data(TRY)

# Extract all traits for species
species_list <- c("Acaena novae-zelandiae", "Adiantum capillus-veneris", "Zuelania guidonia")
extract_traits(species_list, TRY, rank = "species")

# Extract specific traits for species
extract_traits(species_list, TRY, rank = "species",
               traits = c("LA", "LMA", "LeafN", "PlantHeight", "SeedMass", "SSD"))

# Extract specific traits at genus level
genus_list <- c("Acaena", "Adiantum")
extract_traits(genus_list, TRY, rank = "genus",
               traits = c("LDMC", "PlantHeight", "SeedMass"))

}
