% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_set_treatment_effects.R
\name{get_set_treatment_effects}
\alias{get_set_treatment_effects}
\title{Calculate matched set level treatment effects}
\usage{
get_set_treatment_effects(pm.obj, panel.data, lead)
}
\arguments{
\item{pm.obj}{an object of class \code{PanelMatch}}

\item{panel.data}{\code{PanelData} object with the time series cross sectional data used for matching, refinement, and estimation}

\item{lead}{integer (or integer vector) indicating the time period(s) in the future for which the treatment effect size will be calculated. Calculations will be made for the period t + lead, where t is the time of treatment. If more than one lead value is provided, then calculations will be performed for each value.}
}
\value{
a list equal in length to the number of lead periods specified to the \code{lead} argument. Each element in the list is a vector of the matched set level effect estimates.
}
\description{
Calculate the size of treatment effects for each matched set.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
# create subset of data for simplicity
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4, 
                         refinement.method = "ps.match", 
                         match.missing = TRUE, 
                         covs.formula = ~ tradewb,
                         size.match = 5, qoi = "att",
                         lead = 0:4, 
                         forbid.treatment.reversal = FALSE)
set.effects <- get_set_treatment_effects(pm.obj = PM.results, 
                panel.data = dem.sub.panel, lead = 0)


}
