% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PYR.R
\name{PYR}
\alias{PYR}
\title{Percent Yield Reduction (PYR)}
\usage{
PYR(Gen, YN, YS)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}
}
\value{
A data frame with \code{Gen}, \code{PYR}.

\deqn{PYR = \frac{(YN - YS)}{YN} \times 100}
}
\description{
This function computes Percent Yield Reduction (PYR) using any traits (like yield) under stress and non-stress conditions. The lower values of PYR indicates greater tolerance. For more details see Farshadfar and Javadinia (2011).
}
\examples{
out = PYR(
Gen=c("G1","G2","G3"),
YN=c(10,8,5),
YS=c(7,5,3)
)
print(out)
}
\references{
Farshadfar, E. and Javadinia, J. (2011). Evaluation of chickpea (Cicer arietinum L.) genotypes for drought tolerance. Seed and Plant Improvement Journal, 27(4), 517–537.
}
