% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-file-repo-list.R
\name{redcap_file_repo_list_oneshot}
\alias{redcap_file_repo_list_oneshot}
\title{Export a List of Files/Folders from the File Repository}
\usage{
redcap_file_repo_list_oneshot(
  redcap_uri,
  token,
  folder_id = NA_integer_,
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{folder_id}{the integer of a specific folder in the
File Repository for which you wish to export a list of its
files and sub-folders.
If \code{NA} (the default),
the top-level directory of the File Repository will be used.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
Currently, a list is returned with the following elements,
\itemize{
\item \code{data}: A \link[tibble:tibble]{tibble::tibble} with the following columns:
\code{folder_id}, \code{doc_id}, and (file) \code{name}.
Each sub-folder will have an associated \code{folder_id} integer,
and each file will have an associated \code{doc_id} integer.
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{records_affected_count}: The number of records inserted or updated.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
}
}
\description{
Allows you to export a list of all files and sub-folders from a specific
folder in a project's File Repository.
Each sub-folder will have an associated folder_id number,
and each file will have an associated doc_id number.
}
\details{
This functions requires API Export privileges and File Repository privileges
in the project.
(Note: Until
\href{https://redcap.vumc.org/community/post.php?id=243161}{v14.7.3 Standard},
API \emph{import} privileges too.)
}
\examples{
\dontrun{
uri     <- "https://redcap-dev-2.ouhsc.edu/redcap/api/"
token   <- "589740603423E92BC79BAC2811B1F82A" # file-repo

# Top-level directory
REDCapR::redcap_file_repo_list_oneshot(
  redcap_uri    = uri,
  token         = token
)$data

# First subdirectory
REDCapR::redcap_file_repo_list_oneshot(
  redcap_uri    = uri,
  token         = token,
  folder_id     = 1
)$data
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Will Beasley
}
