% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateHazrateLines.R
\name{integrateHazrateLines}
\alias{integrateHazrateLines}
\title{Integrate Hazard-rate line survey distance functions}
\usage{
integrateHazrateLines(
  object,
  newdata = NULL,
  w.lo = NULL,
  w.hi = NULL,
  Units = NULL
)
}
\arguments{
\item{object}{Either an Rdistance fitted distance function
(an object that inherits from class "dfunc"; usually produced 
by a call to \code{\link{dfuncEstim}}), or a matrix of canonical 
distance function parameters (e.g., \code{matrix(exp(fit$par),1)}). 
If a matrix, each row corresponds to a 
distance function and each column is a parameter. The first column is 
the parameter related to sighting covariates and must be transformed 
to the "real" space (i.e., inverse link, which is \eqn{exp()}, must 
be applied outside this routine).  If \code{object} is a matrix, 
it should not have measurement units because
only derived quantities (e.g., ESW) have units; Rdistance function 
parameters themselves never have units.}

\item{newdata}{A data frame containing new values for 
the distance function covariates. If NULL and 
\code{object} is a fitted distance function, the  
observed covariates stored in
\code{object} are used (behavior similar to \code{\link{predict.lm}}).
Argument \code{newdata} is ignored if \code{object} is a matrix.}

\item{w.lo}{Minimum sighting distance or left-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function. 
Must have physical measurement units.}

\item{w.hi}{Maximum sighting distance or right-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function.
Must have physical measurement units.}

\item{Units}{Physical units of sighting distances if 
\code{object} is a matrix. Sighting distance units can differ from units 
of \code{w.lo} or \code{w.hi}.   Ignored if \code{object}
is a fitted distance function.}
}
\value{
A vector of areas under the distance functions represented in 
\code{object}. 
If \code{object} is a distance function and 
\code{newdata} is specified, the returned vector's length is 
\code{nrow(newdata)}.  If \code{object} is a distance function and 
\code{newdata} is NULL, 
returned vector's length is \code{length(distances(object))}. If 
\code{object} is a matrix, return's length is 
\code{nrow(object)}.
}
\description{
Compute integral of the hazard-rate distance function for 
line-transect surveys.
}
\details{
Returned integrals are
\deqn{\int_0^{w} (1 - e^{-(x/\sigma_i)^{-k}}) dx = w - \frac{\sigma_i}{k} \Gamma(-\frac{1}{k}, {\frac{\sigma_i}{w}}^{k}),}{
Integral( 1 - e^{-(x/\sigma_i)^(-k)} ) = w - (s/k)(Gamma(-1/k, (s/w)^k),}
where \eqn{w = w.hi - w.lo}, \eqn{\sigma_i}{s} and \eqn{k}{k} are estimated 
hazard-rate distance 
function parameters for the 
i-th observed distance, and \eqn{\Gamma()}{Gamma()} is the incomplete gamma 
function. 
Rdistance uses the 
incomplete gamma function implemented in 
\code{\link[expint]{gammainc}}, which for 
all intents and purposes is exact.
}
\section{Note}{

Users will not normally call this function. It is called 
internally by \code{\link{nLL}} and \code{\link{effectiveDistance}}.
}

\examples{

# A pre-estimated hazard rate distance function: sparrowDfuncObserver
fit <- sparrowDfuncObserver
table(ESW(fit))
table(integrateHazrateLines(fit))

# Check: Integral of 1 - exp(-(x/s)^(-k)) from 0 to w.hi-w.lo
w <- dropUnits(fit$w.hi - fit$w.lo)
params <- predict(fit)
sigma <- params[,1]
minusk <- -params[,2]

outArea <- w + sigma * 
           expint::gammainc(1/minusk, (w/sigma)^(minusk)) / minusk
table(outArea)

}
\seealso{
\code{\link{integrateNumeric}}; \code{\link{integrateNegexpLines}}; 
\code{\link{integrateOneStepLines}}
}
