% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duane.R
\name{plot.duane}
\alias{plot.duane}
\title{Plot Method for Duane Analysis}
\usage{
\method{plot}{duane}(
  x,
  log = TRUE,
  conf.int = TRUE,
  legend = TRUE,
  legend.pos = "topleft",
  ...
)
}
\arguments{
\item{x}{An object of class \code{"duane"}.}

\item{log}{Logical; whether to use logarithmic scales for axes (default: \code{TRUE}).}

\item{conf.int}{Logical; whether to plot confidence bounds (default: \code{TRUE}).}

\item{legend}{Logical; whether to include a legend (default: TRUE).}

\item{legend.pos}{Position of the legend (default: "topleft").}

\item{...}{Further arguments passed to \code{plot()}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Generates a Duane plot (log-log or linear scale) with fitted regression line
and optional confidence bounds.
}
\examples{
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
fit <- duane(times, failures)
plot(fit, main = "Duane Plot", xlab = "Cumulative Time", ylab = "Cumulative MTBF")
}
\seealso{
Other Duane functions: 
\code{\link{duane}()},
\code{\link{print.duane}()}
}
\concept{Duane functions}
